/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.groups.dom;

import fr.exemole.bdfserver.tools.groups.GroupDefBuilder;
import java.text.ParseException;
import java.util.function.Consumer;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class GroupDefDOMReader {
    private final GroupDefBuilder groupDefBuilder;
    private final MessageHandler messageHandler;

    public GroupDefDOMReader(GroupDefBuilder groupDefBuilder, MessageHandler messageHandler) {
        this.groupDefBuilder = groupDefBuilder;
        this.messageHandler = messageHandler;
    }

    public GroupDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static GroupDefDOMReader init(GroupDefBuilder groupDefBuilder, MessageHandler messageHandler) {
        return new GroupDefDOMReader(groupDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": 
                case "lib": {
                    try {
                        LabelUtils.readLabel(element, GroupDefDOMReader.this.groupDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(GroupDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(GroupDefDOMReader.this.groupDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(GroupDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

