/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.tools.exportation.table.SumCellConverterFactory;

public final class CellConverterProviderFactory {
    private CellConverterProviderFactory() {
    }

    public static CellConverterProvider newInstance(BdfServer bdfServer, ExtractionContext extractionContext, Predicate<SubsetItem> globalPredicate, boolean withLangContextCheck) {
        return new InternalCellConverterProvider(bdfServer, extractionContext, withLangContextCheck, globalPredicate);
    }

    private static class InternalCellConverterProvider
    implements CellConverterProvider {
        private final BdfServer bdfServer;
        private final Map<String, SumCellConverter> engineMap = new HashMap<String, SumCellConverter>();
        private final Set<String> unknownSet = new HashSet<String>();
        private final ExtractionContext extractionContext;
        private final boolean withLangContextCheck;
        private final Predicate<SubsetItem> globalPredicate;

        private InternalCellConverterProvider(BdfServer bdfServer, ExtractionContext extractionContext, boolean withLangContextCheck, Predicate<SubsetItem> globalPredicate) {
            this.bdfServer = bdfServer;
            this.extractionContext = extractionContext;
            this.withLangContextCheck = withLangContextCheck;
            this.globalPredicate = globalPredicate;
        }

        @Override
        public SumCellConverter getCellConverter(String name) {
            SumCellConverter cellConverter = this.engineMap.get(name);
            if (cellConverter != null) {
                return cellConverter;
            }
            if (this.unknownSet.contains(name)) {
                return null;
            }
            TableExport tableExport = this.bdfServer.getTableExportManager().getTableExport(name);
            if (tableExport == null) {
                this.unknownSet.add(name);
                return null;
            }
            ExtractionContext customExtractionContext = this.withLangContextCheck ? BdfServerUtils.checkLangMode(this.extractionContext, this.bdfServer, tableExport.getTableExportDef()) : this.extractionContext;
            cellConverter = SumCellConverterFactory.newInstance(tableExport.getSubsetTableList(), this.bdfServer.getTableExportContext(), customExtractionContext, (CellConverterProvider)this, this.globalPredicate);
            this.engineMap.put(name, cellConverter);
            return cellConverter;
        }
    }
}

