/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.docstream;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.docstream.DynamicDocStreamFactory;
import fr.exemole.bdfserver.tools.docstream.IllustrationDocStream;
import fr.exemole.bdfserver.tools.docstream.StorageContentDocStream;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.xml.DocStreamXMLPackWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.docstream.FileDocStream;
import net.mapeadores.util.io.docstream.StringDocStream;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.ValidExtension;

public final class DocStreamFactory {
    private DocStreamFactory() {
    }

    public static DocStream buildDocStream(BdfServer bdfServer, PathConfiguration pathConfiguration, URI uri) {
        try {
            return DocStreamFactory.parseDocStream(bdfServer, pathConfiguration, uri);
        }
        catch (ErrorMessageException e) {
            return null;
        }
    }

    public static DocStream buildDocStream(BdfServer bdfServer, URI uri) {
        try {
            return DocStreamFactory.parseDocStream(bdfServer, uri);
        }
        catch (ErrorMessageException e) {
            return null;
        }
    }

    public static DocStream parseDocStream(BdfServer bdfServer, URI uri) throws ErrorMessageException {
        return DocStreamFactory.parseDocStream(bdfServer, PathConfigurationBuilder.build(bdfServer), uri);
    }

    public static DocStream parseDocStream(BdfServer bdfServer, PathConfiguration pathConfiguration, URI uri) throws ErrorMessageException {
        if (!uri.isAbsolute()) {
            return null;
        }
        if (uri.isOpaque()) {
            return null;
        }
        String scheme = uri.getScheme();
        if (!scheme.equals("bdf")) {
            return null;
        }
        String path = (uri = uri.normalize()).getPath();
        if (path == null || path.length() == 1) {
            throw new ErrorMessageException("_ error.unsupported.dirlist", "/");
        }
        path = path.substring(1);
        int idx = (path = DocStreamFactory.checkAlias(path)).indexOf(47);
        if (idx == -1) {
            throw new ErrorMessageException("_ error.unsupported.dirlist", path);
        }
        String rootDir = path.substring(0, idx);
        String filePath = path.substring(idx + 1);
        switch (rootDir) {
            case "balayagecontents": 
            case "balayage": {
                return DocStreamFactory.getBalayageContentDocStream(bdfServer, filePath);
            }
            case "dyn": {
                return DynamicDocStreamFactory.getAdminDocStream(bdfServer, filePath);
            }
            case "dyn-pub": {
                return DynamicDocStreamFactory.getPublicDocStream(bdfServer, filePath);
            }
            case "illustrations": {
                return DocStreamFactory.getIllustrationDocStream(bdfServer, filePath);
            }
            case "inc": {
                return DocStreamFactory.getOutputDocStream(bdfServer, "balayages/_inc_/" + filePath);
            }
            case "output": {
                return DocStreamFactory.getOutputDocStream(bdfServer, filePath);
            }
            case "pub": {
                return DocStreamFactory.getPublicDocStream(bdfServer, pathConfiguration, filePath);
            }
            case "tableexport": {
                return DocStreamFactory.getTableExportContentDocStream(bdfServer, filePath);
            }
            case "transformations": 
            case "transformation": {
                return DocStreamFactory.getTransformationContentDocStream(bdfServer, filePath);
            }
            case "xml-pack": {
                return DocStreamFactory.getXmlPackDocStream(bdfServer, pathConfiguration, filePath);
            }
        }
        try {
            RelativePath relativePath = RelativePath.parse(rootDir + "/" + filePath);
            return bdfServer.getResourceStorages().getResourceDocStream(relativePath);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static DocStream getXmlPackDocStream(BdfServer bdfServer, PathConfiguration pathConfiguration, String filePath) throws ErrorMessageException {
        URI uri = BdfURI.toAbsoluteBdfURI(filePath);
        DocStream docStream = DocStreamFactory.parseDocStream(bdfServer, pathConfiguration, uri);
        if (docStream == null) {
            if (filePath.equals("css/fiche.css")) {
                docStream = DocStreamFactory.mergeFicheCss(bdfServer);
            } else {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder();
        DocStreamXMLPackWriter xmlWriter = new DocStreamXMLPackWriter();
        xmlWriter.setAppendable(buf);
        try {
            xmlWriter.appendXMLDeclaration();
            xmlWriter.appendDocStream(docStream, filePath);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return new StringDocStream(buf.toString(), "text/xml");
    }

    private static DocStream getTransformationContentDocStream(BdfServer bdfServer, String filePath) {
        TemplateKey templateKey;
        TransformationKey transformationKey;
        int idx1 = filePath.indexOf(47);
        if (idx1 == -1) {
            return null;
        }
        try {
            transformationKey = TransformationKey.parse(filePath.substring(0, idx1));
        }
        catch (ParseException pe) {
            return null;
        }
        int idx2 = filePath.indexOf(47, idx1 + 1);
        if (idx2 == -1) {
            return null;
        }
        String templateName = filePath.substring(idx1 + 1, idx2);
        String extension = null;
        String contentName = filePath.substring(idx2 + 1);
        int extidx = templateName.lastIndexOf(46);
        if (extidx != -1) {
            extension = templateName.substring(extidx + 1);
            templateName = templateName.substring(0, extidx);
        }
        String mimeType = MimeTypeUtils.getMimeType(bdfServer.getMimeTypeResolver(), contentName);
        if (templateName.equals("_default")) {
            TemplateStorage.Unit unit = extension == null ? BdfTransformationUtils.getHtmlDefaultUnit(bdfServer, transformationKey) : BdfTransformationUtils.getStreamDefaultUnit(bdfServer, transformationKey, extension);
            if (unit != null) {
                for (StorageContent storageContent : unit.getStorageContentList()) {
                    if (!storageContent.getPath().equals(contentName)) continue;
                    return new StorageContentDocStream(storageContent, mimeType);
                }
            }
            return null;
        }
        if (extension == null) {
            try {
                templateKey = TemplateKey.parse(transformationKey, templateName);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        try {
            ValidExtension validExtension = ValidExtension.parse(extension);
            templateKey = TemplateKey.parse(transformationKey, validExtension, templateName);
        }
        catch (ParseException pe) {
            return null;
        }
        StorageContent storageContent = bdfServer.getTransformationManager().getTemplateStorageContent(templateKey, contentName);
        if (storageContent != null) {
            return new StorageContentDocStream(storageContent, mimeType);
        }
        return null;
    }

    private static DocStream getIllustrationDocStream(BdfServer bdfServer, String filePath) {
        int illustrationid;
        SubsetKey albumKey;
        String illustrationName;
        int idx1 = filePath.indexOf(47);
        String dimString = null;
        if (idx1 != -1) {
            if (filePath.indexOf(47, idx1 + 1) != -1) {
                return null;
            }
            dimString = filePath.substring(0, idx1);
            illustrationName = filePath.substring(idx1 + 1);
        } else {
            illustrationName = filePath;
        }
        int idx2 = illustrationName.indexOf(45);
        if (idx2 == -1) {
            return null;
        }
        int idx3 = illustrationName.indexOf(46);
        if (idx3 != -1) {
            if (idx3 < idx2) {
                return null;
            }
            illustrationName = illustrationName.substring(0, idx3);
        }
        try {
            albumKey = SubsetKey.parse((short)5, illustrationName.substring(0, idx2));
        }
        catch (ParseException pe) {
            return null;
        }
        try {
            illustrationid = Integer.parseInt(illustrationName.substring(idx2 + 1));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        Album album = (Album)bdfServer.getFichotheque().getSubset(albumKey);
        if (album == null) {
            return null;
        }
        Illustration illustration = album.getIllustrationById(illustrationid);
        if (illustration == null) {
            return null;
        }
        if (dimString == null) {
            return new IllustrationDocStream(illustration, 202);
        }
        if (dimString.equals("_mini")) {
            return new IllustrationDocStream(illustration, 201);
        }
        AlbumDim albumDim = album.getAlbumMetadata().getAlbumDimByName(dimString);
        if (albumDim == null) {
            return null;
        }
        return new IllustrationDocStream(illustration, albumDim);
    }

    private static DocStream getTableExportContentDocStream(BdfServer bdfServer, String filePath) {
        int index = filePath.indexOf(47);
        if (index == -1) {
            return null;
        }
        String tableExportName = filePath.substring(0, index);
        String contentPath = filePath.substring(index + 1);
        String content = bdfServer.getTableExportManager().getTableExportContent(tableExportName, contentPath);
        if (content == null) {
            return null;
        }
        String mimeType = MimeTypeUtils.getMimeType(bdfServer.getMimeTypeResolver(), contentPath);
        if (mimeType.equals("application/octet-stream")) {
            mimeType = "text/plain";
        }
        return new StringDocStream(content, mimeType);
    }

    private static DocStream getBalayageContentDocStream(BdfServer bdfServer, String filePath) {
        int index = filePath.indexOf(47);
        if (index == -1) {
            return null;
        }
        String balayageName = filePath.substring(0, index);
        String contentPath = filePath.substring(index + 1);
        String content = bdfServer.getBalayageManager().getBalayageContent(balayageName, contentPath);
        if (content == null) {
            return null;
        }
        String mimeType = MimeTypeUtils.getMimeType(bdfServer.getMimeTypeResolver(), contentPath);
        if (mimeType.equals("application/octet-stream")) {
            mimeType = "text/plain";
        }
        return new StringDocStream(content, mimeType);
    }

    private static DocStream getPublicDocStream(BdfServer bdfServer, PathConfiguration pathConfiguration, String filePath) {
        File publicDirectory = pathConfiguration.getPublicDirectory();
        File f = new File(publicDirectory, filePath);
        if (!f.exists()) {
            return null;
        }
        String mimeType = MimeTypeUtils.getMimeType(bdfServer.getMimeTypeResolver(), f.getName());
        FileDocStream fileDocStream = new FileDocStream(f);
        fileDocStream.setMimeType(mimeType);
        return fileDocStream;
    }

    private static DocStream getOutputDocStream(BdfServer bdfServer, String filePath) {
        RelativePath relativePath;
        try {
            relativePath = RelativePath.parse(filePath);
        }
        catch (ParseException pe) {
            return null;
        }
        File f = bdfServer.getOutputStorage().getFile(relativePath);
        if (!f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return null;
        }
        String mimeType = MimeTypeUtils.getMimeType(bdfServer.getMimeTypeResolver(), f.getName());
        FileDocStream fileDocStream = new FileDocStream(f);
        fileDocStream.setMimeType(mimeType);
        return fileDocStream;
    }

    private static String checkAlias(String path) {
        if (path.startsWith("dyn/import")) {
            return "xslt/_" + path.substring(4);
        }
        return path;
    }

    private static DocStream mergeFicheCss(BdfServer bdfServer) {
        String[] paths;
        StringBuilder buf = new StringBuilder();
        for (String path : paths = new String[]{"css/fiche-elements.css", "css/fiche-classes.css"}) {
            RelativePath relativePath = RelativePath.build(path);
            DocStream docStream = bdfServer.getResourceStorages().getResourceDocStream(relativePath);
            if (docStream == null) continue;
            buf.append(docStream.getContent());
            buf.append("\n");
        }
        return new StringDocStream(buf.toString(), "text/css");
    }
}

