/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractBalayageUnitRunner;
import fr.exemole.bdfserver.tools.balayage.engine.runners.IllustrationOutputRunner;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.album.Album;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.utils.SelectionUtils;

public class IllustrationBalayageUnitRunner
extends AbstractBalayageUnitRunner {
    private IllustrationOutputRunner[] outputRunnerArray;

    public IllustrationBalayageUnitRunner(BalayageParameters balayageParameters, int balayageIndex, BalayageUnit balayageUnit) {
        super(balayageParameters, balayageIndex, balayageUnit);
        ArrayList<IllustrationOutputRunner> outputList = new ArrayList<IllustrationOutputRunner>();
        int p = 0;
        for (BalayageOutput output : balayageUnit.getOutputList()) {
            IllustrationOutputRunner outputRunner = new IllustrationOutputRunner(balayageParameters, p, output, balayageIndex);
            if (!outputRunner.isValid()) continue;
            outputList.add(outputRunner);
            ++p;
        }
        this.outputRunnerArray = outputList.toArray(new IllustrationOutputRunner[outputList.size()]);
    }

    @Override
    protected void run(String balayageUnitType) {
        IllustrationQuery illustrationQuery = this.balayageUnit.getIllustrationQuery();
        Album[] albumArray = SelectionUtils.toAlbumArray(this.fichotheque, illustrationQuery, this.extractionContext.getSubsetAccessPredicate());
        List<String> albumDimNameList = illustrationQuery.getAlbumDimNameList();
        for (Album album : albumArray) {
            for (IllustrationOutputRunner outputRunner : this.outputRunnerArray) {
                outputRunner.copy(album, albumDimNameList, System.currentTimeMillis());
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        int length = this.outputRunnerArray.length;
        for (int i = 0; i < length; ++i) {
            this.outputRunnerArray[i].dispose();
            this.outputRunnerArray[i] = null;
        }
        this.outputRunnerArray = null;
    }

    @Override
    protected boolean isEmpty() {
        return this.outputRunnerArray.length == 0;
    }
}

