/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.apps;

import java.util.Map;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.text.StringUtils;

public class AppConf {
    public static final String ARGS_PREFIX = "args_";
    public static final String ACTIVE = "active";
    public static final String MULTI_ACTIVE = "multi_active";
    public static final String MULTI_NOAUTHENTIFICATION = "multi_noauthentication";
    public static final String CORE_JSLIBS = "core_jslibs";
    public static final String CORE_JQUERYEXTENSIONS = "core_jqueryextensions";
    public static final String CORE_CODEMIRRORMODES = "core_codemirrormodes";
    public static final String CORE_LEAFLETEXTENSIONS = "core_leafletextensions";
    public static final String CORE_THIRDLIBS = "core_thirdlibs";
    public static final String CORE_THEMECSSFILES = "core_themecssfiles";
    public static final String CORE_INCLUDEFICHECSS = "core_includefichecss";
    public static final String CORE_JSORDER = "core_jsorder";
    public static final String CORE_BODYCSSCLASS = "core_bodycssclass";
    public static final String CORE_BDFUSERNEED = "core_bdfuserneed";
    public static final String CORE_TITLEPHRASENAME = "core_titlephrasename";
    public static final String LOGIN_SESSIONMESSAGE = "login_sessionmessage";
    public static final String LOGIN_AVAILABLESPHERES = "login_availablespheres";
    public static final String LOGIN_DEFAULTSPHERE = "login_defaultsphere";
    public static final String LOGIN_TITLEPHRASENAME = "login_titlephrasename";
    private final String appName;
    private final Map<String, String> iniMap;

    public AppConf(String appName, Map<String, String> iniMap) {
        this.appName = appName;
        this.iniMap = iniMap;
    }

    public String getAppName() {
        return this.appName;
    }

    public JsObject getArgsJsObject() {
        boolean done = false;
        JsObject jsObject = JsObject.init();
        for (Map.Entry<String, String> entry : this.iniMap.entrySet()) {
            String name;
            String key = entry.getKey();
            if (!key.startsWith(ARGS_PREFIX) || (name = key.substring(ARGS_PREFIX.length())).length() <= 0) continue;
            jsObject.put(name, entry.getValue());
            done = true;
        }
        if (done) {
            return jsObject;
        }
        return null;
    }

    public String[] getArray(String paramName) {
        String value = this.iniMap.get(paramName);
        if (value == null) {
            return StringUtils.EMPTY_STRINGARRAY;
        }
        return StringUtils.getTechnicalTokens(value, true);
    }

    public boolean getBoolean(String paramName) {
        boolean defaultValue = false;
        String value = this.iniMap.get(paramName);
        if (value == null) {
            return defaultValue;
        }
        switch (value = value.toLowerCase().trim()) {
            case "": {
                return defaultValue;
            }
            case "0": 
            case "false": {
                return false;
            }
            case "1": 
            case "true": {
                return true;
            }
        }
        return defaultValue;
    }

    public String getString(String paramName) {
        return this.iniMap.get(paramName);
    }

    public String getString(String paramName, String defaultValue) {
        String value = this.iniMap.get(paramName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

