/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.servlets.BDFRoutes;
import fr.exemole.bdfserver.servlets.BDFUtils;
import fr.exemole.bdfserver.servlets.BDFWebapp;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.mapeadores.util.servlets.HttpAccessException;
import net.mapeadores.util.servlets.HttpServletRequestMap;
import net.mapeadores.util.servlets.MultiPartParser;
import net.mapeadores.util.servlets.exceptions.NotFoundException;
import net.mapeadores.util.servlets.multipart.DefaultMultiPartParser;

public class BDFServlet
extends HttpServlet {
    private final MultiPartParser multiPartParser = new DefaultMultiPartParser();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.processRequest(request, response);
        }
        catch (HttpAccessException hae) {
            this.sendError(request, response, hae);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.processRequest(request, response);
        }
        catch (HttpAccessException hae) {
            this.sendError(request, response, hae);
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, HttpAccessException hae) throws IOException {
        String messageText = hae.getMessage();
        if (messageText == null) {
            messageText = request.getServletPath() + request.getPathInfo();
        }
        response.sendError(hae.getHttpType(), messageText);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            throw new NotFoundException();
        }
        BDFWebapp bdfWebapp = (BDFWebapp)this.getServletContext().getAttribute("fr.exemole.BDFWebapp");
        if (pathInfo.equals("/")) {
            if (bdfWebapp.isMultiBdf()) {
                String fichothequeRedirect = BDFUtils.getFichothequeRedirect(bdfWebapp.getMulti());
                if (fichothequeRedirect != null) {
                    response.sendRedirect(fichothequeRedirect + "/" + "session");
                } else {
                    response.sendRedirect("multi-admin");
                }
            } else {
                response.sendRedirect("session");
            }
            return;
        }
        pathInfo = pathInfo.substring(1);
        HttpServletRequestMap requestMap = new HttpServletRequestMap(request, this.multiPartParser);
        if (bdfWebapp.isMultiBdf()) {
            try {
                BDFRoutes.resolveMulti(bdfWebapp, pathInfo, requestMap, response);
            }
            catch (HttpAccessException hae) {
                if (hae.isUnresolvedMessage()) {
                    hae.resolveMessage(bdfWebapp.getMulti().getAdminMessageLocalisation());
                }
                throw hae;
            }
        }
        BdfServer bdfServer = bdfWebapp.getUnique().getBdfServer();
        try {
            BDFRoutes.resolveBdfServer(bdfWebapp, bdfServer, pathInfo, requestMap, response);
        }
        catch (HttpAccessException hae) {
            if (hae.isUnresolvedMessage()) {
                hae.resolveMessage(BdfInstructionUtils.getMessageLocalisation(requestMap, bdfServer, null));
            }
            throw hae;
        }
    }
}

