/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.tools.dom;

import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import net.fichotheque.tools.dom.AbstractMetadataDOMReader;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class MultiMetadataDOMReader
extends AbstractMetadataDOMReader {
    private final MultiMetadataEditor multiMetadataEditor;

    public MultiMetadataDOMReader(MultiMetadataEditor multiMetadataEditor, MessageHandler messageHandler) {
        super(multiMetadataEditor, messageHandler);
        this.multiMetadataEditor = multiMetadataEditor;
    }

    public void read(Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        RootConsumer rootConsumer = new RootConsumer(attributesBuilder, "/" + element.getTagName());
        DOMUtils.readChildren(element, rootConsumer);
        this.flush(attributesBuilder);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final AttributesBuilder attributesBuilder;
        private final String parentXpath;

        private RootConsumer(AttributesBuilder attributesBuilder, String parentXpath) {
            this.attributesBuilder = attributesBuilder;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            if (MultiMetadataDOMReader.this.readCommonElement(element, this.attributesBuilder, this.parentXpath)) {
                return;
            }
            String tagName = element.getTagName();
            String xpath = this.parentXpath + "/" + tagName;
            if (tagName.equals("authority")) {
                String authority = DOMUtils.readSimpleElement(element);
                if (StringUtils.isAuthority(authority)) {
                    MultiMetadataDOMReader.this.multiMetadataEditor.setAuthority(authority);
                } else {
                    DomMessages.wrongElementValue(MultiMetadataDOMReader.this.messageHandler, xpath, authority);
                }
            } else if (tagName.equals("working-langs")) {
                LinkedHashSet<Lang> langSet = new LinkedHashSet<Lang>();
                LangsUtils.readLangElements(langSet, element, MultiMetadataDOMReader.this.messageHandler, xpath);
                if (!langSet.isEmpty()) {
                    MultiMetadataDOMReader.this.multiMetadataEditor.setWorkingLangs(LangsUtils.fromCollection(langSet));
                }
            }
        }
    }
}

