/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.personmanager;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.personmanager.AbstractPersonMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class PersonAddCommand
extends AbstractPersonMultiCommand {
    public static final String COMMAND_NAME = "PersonAdd";
    public static final String TARGET_PARAMNAME = "target";
    public static final String FICHOTHEQUES_PARAMNAME = "fichotheques";
    public static final String ALL_PARAMVALUE = "all";
    public static final String SELECTION_PARAMVALUE = "selection";

    public PersonAddCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        this.initPersonParameters();
        return this.runAdd();
    }

    private CommandMessage runAdd() throws ErrorMessageException {
        AbstractPersonMultiCommand.CopyOrigin copyOrigin = this.getCopyOrigin();
        List<BdfServer> bdfServerList = this.getBdfServerList();
        if (bdfServerList.isEmpty()) {
            return null;
        }
        for (BdfServer bdfServer : bdfServerList) {
            this.createRedacteur(bdfServer, copyOrigin);
        }
        return this.done("_ done.multi.personadd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRedacteur(BdfServer bdfServer, AbstractPersonMultiCommand.CopyOrigin copyOrigin) {
        Redacteur originRedacteur = copyOrigin.getRedacteur();
        BdfServer bdfServer2 = bdfServer;
        synchronized (bdfServer2) {
            try (EditSession editSession = bdfServer.initEditSession("_admin", COMMAND_NAME);){
                SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                try {
                    Redacteur newRedacteur = sphereEditor.createRedacteur(-1, this.login);
                    sphereEditor.setPerson(newRedacteur, originRedacteur.getPersonCore());
                    sphereEditor.setEmail(newRedacteur, originRedacteur.getEmailCore());
                    bdfServer.getPasswordManager().setEncryptedPassword(newRedacteur.getGlobalId(), copyOrigin.getEncryptedPassword());
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException("Test done before");
                }
            }
        }
    }

    private List<BdfServer> getBdfServerList() throws ErrorMessageException {
        String targetValue = this.requestMap.getParameter(TARGET_PARAMNAME);
        ArrayList<BdfServer> bdfServerList = new ArrayList<BdfServer>();
        if (targetValue != null && targetValue.equals(SELECTION_PARAMVALUE)) {
            String[] fichotheques = this.requestMap.getParameterValues(FICHOTHEQUES_PARAMNAME);
            if (fichotheques == null) {
                throw BdfErrors.emptyMandatoryParameter(FICHOTHEQUES_PARAMNAME);
            }
            for (String name : fichotheques) {
                this.populateList(bdfServerList, name);
            }
        } else {
            for (String name : this.multi.getExistingNameSet()) {
                this.populateList(bdfServerList, name);
            }
        }
        return bdfServerList;
    }

    private void populateList(List<BdfServer> bdfServerList, String name) {
        Redacteur existing;
        Sphere sphere;
        BdfServer bdfServer = this.multi.getInitBdfServer(name);
        if (bdfServer != null && (sphere = (Sphere)bdfServer.getFichotheque().getSubset(this.sphereKey)) != null && (existing = sphere.getRedacteurByLogin(this.login)) == null) {
            bdfServerList.add(bdfServer);
        }
    }
}

