/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.html.BdfHtmlProducer;
import fr.exemole.bdfserver.html.JsLibProvider;
import fr.exemole.bdfserver.html.jslib.JsLibCatalog;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.jslib.AppJsLibFactory;
import fr.exemole.bdfserver.tools.jslib.BdfJsLibBuilder;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.text.RelativePath;

public final class AppInit {
    private final BdfHtmlProducer htmlProducer;
    private final AppConf appConf;
    private final String appName;
    private final ResourceStorages resourceStorages;
    private final ExtensionManager extensionManager;

    private AppInit(BdfHtmlProducer htmProducer, AppConf appConf, ResourceStorages resourceStorages, ExtensionManager extensionManager) {
        this.htmlProducer = htmProducer;
        this.appConf = appConf;
        this.appName = appConf.getAppName();
        this.resourceStorages = resourceStorages;
        this.extensionManager = extensionManager;
    }

    private void run() {
        JsLib thirdLibs;
        this.htmlProducer.setWithJavascript(true);
        if (this.appConf.getBoolean("core_includefichecss")) {
            this.htmlProducer.addFicheCss(false);
        }
        if ((thirdLibs = this.getThirdLibs()) != null) {
            this.htmlProducer.addJsLib(thirdLibs);
        }
        for (String jslibName : this.appConf.getArray("core_jslibs")) {
            int idx = jslibName.indexOf(":");
            if (idx == -1) {
                JsLib jsLib = JsLibCatalog.CORE.getJsLib(jslibName);
                if (jsLib != null) {
                    this.htmlProducer.addJsLib(jsLib);
                    continue;
                }
                this.htmlProducer.addLog("[core_jslibs] Unknown jsLib: " + jslibName);
                continue;
            }
            if (this.extensionManager != null) {
                String extensionName = jslibName.substring(0, idx);
                BdfExtensionReference reference = this.extensionManager.getBdfExtensionReference(extensionName);
                if (reference != null) {
                    JsLibProvider jsLibProvider = (JsLibProvider)reference.getImplementation(JsLibProvider.class);
                    if (jsLibProvider != null) {
                        JsLib jsLib = jsLibProvider.getJsLib(jslibName.substring(idx + 1));
                        if (jsLib != null) {
                            this.htmlProducer.addJsLib(jsLib);
                            continue;
                        }
                        this.htmlProducer.addLog("[core_jslibs] Unknown extension jslib: " + jslibName);
                        continue;
                    }
                    this.htmlProducer.addLog("[core_jslibs] extension has no jslib provider: " + extensionName);
                    continue;
                }
                this.htmlProducer.addLog("[core_jslibs] Unknown extension: " + extensionName);
                continue;
            }
            this.htmlProducer.addLog("[core_jslibs] No extension manager: " + jslibName);
        }
        this.htmlProducer.addJsLib(AppJsLibFactory.newInstance(this.resourceStorages, this.appConf));
        this.htmlProducer.addThemeCss(this.appConf.getArray("core_themecssfiles"));
        this.populateAppThemeCss();
        this.populateSupplementaryCss();
        String bodyCssClass = this.appConf.getString("core_bodycssclass");
        if (bodyCssClass != null) {
            this.htmlProducer.setBodyCssClass(bodyCssClass);
        }
        this.populateCustomCss();
    }

    private void populateAppThemeCss() {
        RelativePath themeCssFolderPath = StorageUtils.buildAppResourcePath(this.appName, "theme/css");
        for (ResourceStorage resourceStorage : this.resourceStorages) {
            ResourceFolder cssFolder = resourceStorage.getResourceFolder(themeCssFolderPath);
            if (cssFolder == null) continue;
            for (String resourceName : cssFolder.getResourceNameList()) {
                if (!resourceName.endsWith(".css")) continue;
                this.htmlProducer.addAppThemeCss(this.appName, resourceName);
            }
        }
    }

    private void populateSupplementaryCss() {
        RelativePath cssFolderPath = StorageUtils.buildAppResourcePath(this.appName, "css");
        for (ResourceStorage resourceStorage : this.resourceStorages) {
            ResourceFolder cssFolder = resourceStorage.getResourceFolder(cssFolderPath);
            if (cssFolder == null) continue;
            for (String resourceName : cssFolder.getResourceNameList()) {
                if (!resourceName.endsWith(".css")) continue;
                this.htmlProducer.addSupplementaryCss(cssFolderPath.buildChild(resourceName));
            }
        }
    }

    private void populateCustomCss() {
        RelativePath appCssPath = RelativePath.build("custom/app-" + this.appName + ".css");
        if (this.resourceStorages.containsResource(appCssPath)) {
            this.htmlProducer.addCustomCss(appCssPath);
        }
    }

    private JsLib getThirdLibs() {
        String[] thirdLibs;
        String[] leafletExtensions;
        String[] codemirrorModes;
        boolean done = false;
        BdfJsLibBuilder builder = BdfJsLibBuilder.init();
        String[] jqueryExtensions = this.appConf.getArray("core_jqueryextensions");
        if (jqueryExtensions.length > 0) {
            done = true;
            builder.addThirdLib("jquery", jqueryExtensions);
        }
        if ((codemirrorModes = this.appConf.getArray("core_codemirrormodes")).length > 0) {
            done = true;
            builder.addThirdLib("codemirror", codemirrorModes);
        }
        if ((leafletExtensions = this.appConf.getArray("core_leafletextensions")).length > 0) {
            done = true;
            builder.addThirdLib("leaflet", leafletExtensions);
        }
        if ((thirdLibs = this.appConf.getArray("core_thirdlibs")).length > 0) {
            done = true;
            for (String thirdLib : thirdLibs) {
                builder.addThirdLib(thirdLib, new String[0]);
            }
        }
        if (done) {
            return builder.toJsLib();
        }
        return null;
    }

    public static void init(BdfHtmlProducer htmlProducer, AppConf appConf, ResourceStorages resourceStorages, @Nullable ExtensionManager extensionManager) {
        AppInit appInit = new AppInit(htmlProducer, appConf, resourceStorages, extensionManager);
        appInit.run();
    }
}

