/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.SphereOdsProducer;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.text.FileName;

public class UsersInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String filePath;

    public UsersInstruction(BdfServer bdfServer, String filePath) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Sphere activeSphere;
        FileName fileName;
        try {
            fileName = FileName.parse(this.filePath);
        }
        catch (ParseException pe) {
            return null;
        }
        if (!fileName.getExtension().equals("ods")) {
            return null;
        }
        String baseName = fileName.getBasename();
        boolean isFichothequeAdmin = BdfUserUtils.isAdmin(this.bdfServer, bdfUser);
        if (baseName.equals("_all")) {
            if (!isFichothequeAdmin) {
                throw new ForbiddenException();
            }
            activeSphere = null;
        } else {
            PermissionSummary permissionSummary;
            try {
                SubsetKey sphereKey = SubsetKey.parse((short)3, baseName);
                activeSphere = (Sphere)this.bdfServer.getFichotheque().getSubset(sphereKey);
            }
            catch (ParseException pe) {
                return null;
            }
            if (activeSphere == null) {
                return null;
            }
            if (!isFichothequeAdmin && !(permissionSummary = PermissionSummaryBuilder.build(this.bdfServer, bdfUser)).isSubsetAdmin(activeSphere.getSubsetKey())) {
                throw new ForbiddenException();
            }
        }
        return StreamResponseHandler.init(new SphereOdsProducer(this.bdfServer, bdfUser, activeSphere));
    }
}

