/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.croisement.LienBufferParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class MotcleIndexationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleIndexation";
    public static final String COMMANDKEY = "_ THS-13";
    private Motcle motcle;
    private List<CroisementByCorpus> croisementByCorpusList;

    public MotcleIndexationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            CroisementEditor croisementEditor = session.getFichothequeEditor().getCroisementEditor();
            ArrayList<IncludeKey> scopeList = new ArrayList<IncludeKey>();
            for (CroisementByCorpus croisementByCorpus : this.croisementByCorpusList) {
                scopeList.add(IncludeKey.newInstance(croisementByCorpus.corpus.getSubsetKey()));
            }
            CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.clearExistingEngine(this.motcle, scopeList);
            for (CroisementByCorpus croisementByCorpus : this.croisementByCorpusList) {
                List lienBufferList = croisementByCorpus.croisementList;
                for (LienBuffer lienBuffer : lienBufferList) {
                    croisementChangeEngine.addLien(lienBuffer);
                }
            }
            croisementEditor.updateCroisements(this.motcle, croisementChangeEngine.toCroisementChanges());
        }
        this.putResultObject("obj.thesaurus", this.motcle.getThesaurus());
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.thesaurus.motcleindexation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        PermissionSummary permissionSummary = this.getPermissionSummary();
        this.croisementByCorpusList = new ArrayList<CroisementByCorpus>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            String param_value;
            if (!permissionSummary.hasAccess(corpus) || (param_value = this.requestHandler.getTrimedParameter(corpus.getSubsetKeyString())).isEmpty()) continue;
            this.croisementByCorpusList.add(this.parse(corpus, param_value));
        }
    }

    private CroisementByCorpus parse(Corpus corpus, String chaine) {
        String[] tokens = StringUtils.getTechnicalTokens(chaine, false);
        ArrayList<LienBuffer> lienBufferList = new ArrayList<LienBuffer>();
        for (String token : tokens) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parseId(corpus, token, null, -1);
                lienBufferList.add(lienBuffer);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new CroisementByCorpus(corpus, lienBufferList);
    }

    private static class CroisementByCorpus {
        private final Corpus corpus;
        private final List<LienBuffer> croisementList;

        private CroisementByCorpus(Corpus corpus, List<LienBuffer> croisementList) {
            this.corpus = corpus;
            this.croisementList = croisementList;
        }
    }
}

