/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

public class MotcleCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleCreation";
    public static final String COMMANDKEY = "_ THS-08";
    public static final String NEWIDALPHA_PARAMNAME = "newidalpha";
    public static final String NEWLABEL_PARAMPREFIX = "newlabel/";
    public static final String BABELIEN_NEWLANG_PARAMNAME = "babeliennewlang";
    public static final String BABELIEN_NEWLABEL_PARAMNAME = "babeliennewlabel";
    public static final String PARENT_PARAMNAME = "parent";
    private Thesaurus thesaurus;
    private String newIdalpha;
    private LabelChange motcleLabelChange;
    private Lang babelienLang;
    private String babelienNewLabel;
    private Motcle parentMotcle;

    public MotcleCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Motcle newMotcle;
        block15: {
            try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
                ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(this.thesaurus);
                try {
                    newMotcle = thesaurusEditor.createMotcle(-1, this.newIdalpha);
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException("test done before");
                }
                if (this.motcleLabelChange != null) {
                    ThesaurusUtils.changeMotcleLabels(thesaurusEditor, newMotcle, this.motcleLabelChange);
                } else if (this.babelienNewLabel != null) {
                    TypoOptions typoOptions = TypoOptions.getTypoOptions(this.babelienLang.toLocale());
                    thesaurusEditor.putLabel(newMotcle, this.babelienLang, TypoParser.parseTypo(this.babelienNewLabel, typoOptions));
                }
                if (this.parentMotcle == null) break block15;
                try {
                    thesaurusEditor.setParent(newMotcle, this.parentMotcle);
                }
                catch (ParentRecursivityException pre) {
                    throw new ShouldNotOccurException("child just created");
                }
            }
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        this.putResultObject("obj.motcle", newMotcle);
        if (this.newIdalpha != null) {
            this.setDone("_ done.thesaurus.motclecreation_idalpha", new Object[0]);
        } else {
            this.setDone("_ done.thesaurus.motclecreation_id", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        short thesaurusType = this.thesaurus.getThesaurusMetadata().getThesaurusType();
        if (thesaurusType == 2) {
            this.newIdalpha = this.getMandatory(NEWIDALPHA_PARAMNAME);
            this.newIdalpha = StringUtils.cleanString(this.newIdalpha);
            if (this.newIdalpha.length() == 0) {
                throw BdfErrors.error("_ error.empty.idalpha");
            }
            if (!Idalpha.isValid(this.newIdalpha)) {
                throw BdfErrors.error("_ error.wrong.idalpha", this.newIdalpha);
            }
            Motcle other = this.thesaurus.getMotcleByIdalpha(this.newIdalpha);
            if (other != null) {
                throw BdfErrors.error("_ error.existing.idalpha", this.newIdalpha);
            }
        }
        if (thesaurusType == 3) {
            this.babelienNewLabel = this.getMandatory(BABELIEN_NEWLABEL_PARAMNAME);
            String langString = this.getMandatory(BABELIEN_NEWLANG_PARAMNAME).trim();
            if (langString.length() > 0) {
                try {
                    this.babelienLang = Lang.parse(langString);
                }
                catch (ParseException lie) {
                    throw BdfErrors.error("_ error.wrong.lang", langString);
                }
            }
        } else {
            this.motcleLabelChange = this.requestHandler.getLabelChange(NEWLABEL_PARAMPREFIX);
        }
        this.parentMotcle = (Motcle)this.requestHandler.getOptionnalSubsetItem(this.thesaurus, PARENT_PARAMNAME);
    }
}

