/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurRoleCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurRole";
    public static final String COMMANDKEY = "_ ROL-04";
    public static final String ADMIN_PARAMNAME = "admin";
    public static final String ROLE_PARAMNAME = "role";
    private Boolean isAdmin;
    private Redacteur redacteur;
    private Set<String> roleNameSet;

    public RedacteurRoleCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            this.changeRoles(bdfServerEditor);
            if (this.isAdmin != null) {
                bdfServerEditor.setAdmin(this.redacteur.getGlobalId(), this.isAdmin);
            }
        }
        this.setDone("_ done.sphere.redacteurrole", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        PermissionManager permissionManager = this.bdfServer.getPermissionManager();
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        String status = this.redacteur.getStatus();
        boolean admin = this.requestHandler.isTrue(ADMIN_PARAMNAME);
        switch (status) {
            case "inactive": 
            case "readonly": {
                if (!admin) break;
                throw BdfErrors.error("_ error.unsupported.notadminstatus", this.redacteur.getBracketStyle());
            }
        }
        boolean current = permissionManager.isAdmin(this.redacteur);
        if (current == admin) {
            this.isAdmin = null;
        } else {
            if (current && this.bdfServer.getPermissionManager().getAdminRedacteurList().size() == 1) {
                throw BdfErrors.error("_ error.unsupported.lastadmin", this.redacteur.getBracketStyle());
            }
            this.isAdmin = admin;
        }
        this.roleNameSet = new HashSet<String>();
        for (String token : this.requestHandler.getTokens(ROLE_PARAMNAME)) {
            this.roleNameSet.add(token);
        }
    }

    private void changeRoles(BdfServerEditor bdfServerEditor) {
        PermissionManager permissionManager = this.bdfServer.getPermissionManager();
        List<Role> currentRoleList = permissionManager.getRoleList(this.redacteur);
        ArrayList<Role> removeList = new ArrayList<Role>();
        for (Role role : currentRoleList) {
            String name = role.getName();
            if (this.roleNameSet.contains(name)) continue;
            removeList.add(role);
        }
        for (Role role : removeList) {
            bdfServerEditor.unlink(this.redacteur.getGlobalId(), role);
        }
        for (String roleName : this.roleNameSet) {
            Role role = permissionManager.getRole(roleName);
            if (role == null) continue;
            bdfServerEditor.link(this.redacteur, role);
        }
    }
}

