/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.tools.exportation.table.TableExportDefBuilder;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.StringUtils;

public class TableExportDefChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportDefChange";
    public static final String COMMANDKEY = "_ EXP-13";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    public static final String LANGMODE_PARAMNAME = "langmode";
    public static final String LANGLIST_PARAMNAME = "langlist";
    private TableExportDef tableExportDef;

    public TableExportDefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TableExportDescription tableExportDescription = this.bdfServer.getTableExportManager().putTableExportDef(this.tableExportDef, editOrigin);
        this.putResultObject("obj.tableexportdescription", tableExportDescription);
        this.setDone("_ done.exportation.tableexportdefchange", this.tableExportDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String langMode;
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        if (!tableExportDescription.isEditable()) {
            throw BdfErrors.unsupportedNotEditableParameterValue("tableexport", tableExportDescription.getName());
        }
        TableExportDefBuilder tableExportDefBuilder = new TableExportDefBuilder(tableExportDescription.getName(), tableExportDescription.getTableExportDef().getAttributes());
        LabelChange labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        for (Label label : labelChange.getChangedLabels()) {
            tableExportDefBuilder.putLabel(label);
        }
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            tableExportDefBuilder.getAttributesBuilder().changeAttributes(AttributeParser.parse(attributes));
        }
        if ((langMode = TableExportDefChangeCommand.checkLangMode(this.requestHandler.getTrimedParameter(LANGMODE_PARAMNAME))) != null && langMode.equals("custom")) {
            String langListString = this.getMandatory(LANGLIST_PARAMNAME);
            String[] tokens = StringUtils.getTechnicalTokens(langListString, true);
            boolean done = false;
            for (String token : tokens) {
                try {
                    Lang lang = Lang.parse(token);
                    done = true;
                    tableExportDefBuilder.addLang(lang);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!done) {
                langMode = null;
            }
        }
        tableExportDefBuilder.setLangMode(langMode);
        this.tableExportDef = tableExportDefBuilder.toTableExportDef();
    }

    private static String checkLangMode(String langMode) {
        switch (langMode) {
            case "working": 
            case "supplementary": 
            case "custom": {
                return langMode;
            }
        }
        return null;
    }
}

