/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.runners.ScrutariExportRunner;
import java.io.IOException;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ScrutariExportRunCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ScrutariExportRun";
    private ScrutariExportDef scrutariExportDef;

    public ScrutariExportRunCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() {
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(this.bdfServer);
        try {
            ScrutariExportRunner.run(this.scrutariExportDef, this.bdfServer, pathConfiguration);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        this.putResultObject("obj.scrutariexportdef", this.scrutariExportDef);
        this.putResultObject("obj.pathconfiguration", pathConfiguration);
        this.setDone("_ done.exportation.scrutariexportrun", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.scrutariExportDef = this.requestHandler.getMandatoryScrutariExportDef();
    }
}

