/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.runners.BalayageRunner;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class BalayageRunCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BalayageRun";
    public static final String MODE_PARAMNAME = "mode";
    private BalayageDescription balayageDescription;
    private String mode;

    public BalayageRunCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() {
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(this.bdfServer);
        BalayageRunner.Result result = BalayageRunner.run(this.balayageDescription, this.mode, this.bdfServer, pathConfiguration);
        this.putResultObject("obj.templatedescription", this.balayageDescription);
        if (result.hasError()) {
            this.setCommandMessage(result.getError());
        } else {
            this.putResultObject("obj.balayagelog", result.getBalayageLog());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.getPermissionChecker().checkAdmin("balayagerun");
        this.balayageDescription = this.requestHandler.getMandatoryBalayageDescription();
        this.mode = this.requestHandler.getTrimedParameter(MODE_PARAMNAME);
        if (this.mode.isEmpty()) {
            this.mode = null;
        } else if (!BalayageUtils.containsMode(this.balayageDescription.getBalayageDef(), this.mode)) {
            throw BdfErrors.unknownParameterValue(MODE_PARAMNAME, this.mode);
        }
    }
}

