/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CroisementCopyCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CroisementCopy";
    public static final String COMMANDKEY = "_ CRP-29";
    public static final String DESTINATION_PARAMNAME = "destination";
    public static final String DOCUMENTS_PARAMNAME = "documents";
    public static final String ILLUSTRATIONS_PARAMNAME = "illustrations";
    public static final String MOTCLES_PARAMNAME = "motcles";
    private FicheMeta origin;
    private FicheMeta destination;
    private CroisementSubsetEligibility croisementEligibility;

    public CroisementCopyCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            FichothequeTools.copyCroisements(session.getFichothequeEditor().getCroisementEditor(), this.origin, this.destination, this.croisementEligibility);
        }
        this.putResultObject("obj.corpus", this.origin.getCorpus());
        this.putResultObject("obj.fichemeta", this.origin);
        this.putResultObject("obj.destination", this.destination);
        this.setDone("_ done.corpus.croisementcopy", this.destination.getGlobalId());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.origin = this.requestHandler.getMandatoryFicheMeta();
        String destinationParam = this.getMandatory(DESTINATION_PARAMNAME);
        try {
            this.destination = (FicheMeta)FichothequeUtils.parseGlobalId(destinationParam, this.fichotheque, (short)1, this.origin.getCorpus());
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.id", destinationParam);
        }
        this.getPermissionChecker().checkWrite(this.origin).checkWrite(this.destination);
        this.croisementEligibility = new CroisementSubsetEligibility();
        int count = 0;
        count += this.checkCroisement(DOCUMENTS_PARAMNAME, (short)4);
        count += this.checkCroisement(ILLUSTRATIONS_PARAMNAME, (short)5);
        if ((count += this.checkCroisement(MOTCLES_PARAMNAME, (short)2)) == 0) {
            throw BdfErrors.error("_ error.empty.elementselection");
        }
    }

    private int checkCroisement(String paramName, short subsetCategory) throws ErrorMessageException {
        String[] values = this.requestHandler.getTokens(paramName);
        int count = 0;
        for (String value : values) {
            try {
                SubsetItem subsetItem = FichothequeUtils.parseGlobalId(value, this.fichotheque, subsetCategory, null);
                this.croisementEligibility.add(subsetItem);
                ++count;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return count;
    }

    private static class CroisementSubsetEligibility
    implements SubsetEligibility {
        private final Map<SubsetKey, CroisementPredicate> map = new HashMap<SubsetKey, CroisementPredicate>();

        private CroisementSubsetEligibility() {
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            return this.map.containsKey(subsetKey);
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            return this.map.get(subset.getSubsetKey());
        }

        private void add(SubsetItem subsetItem) {
            SubsetKey subsetKey = subsetItem.getSubsetKey();
            CroisementPredicate predicate = this.map.get(subsetKey);
            if (predicate == null) {
                predicate = new CroisementPredicate();
                this.map.put(subsetKey, predicate);
            }
            predicate.add(subsetItem);
        }
    }

    private static class CroisementPredicate
    implements Predicate<SubsetItem> {
        private final Set<SubsetItem> set = new HashSet<SubsetItem>();

        private CroisementPredicate() {
        }

        private void add(SubsetItem subsetItem) {
            this.set.add(subsetItem);
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.set.contains(subsetItem);
        }
    }
}

