/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;

public interface XMLWriter {
    public XMLWriter startOpenTag(String var1) throws IOException;

    public XMLWriter startOpenTag(String var1, boolean var2) throws IOException;

    public XMLWriter endOpenTag() throws IOException;

    public XMLWriter closeEmptyTag() throws IOException;

    public XMLWriter openTag(String var1) throws IOException;

    public XMLWriter openTag(String var1, boolean var2) throws IOException;

    public XMLWriter closeTag(String var1) throws IOException;

    public XMLWriter closeTag(String var1, boolean var2) throws IOException;

    public XMLWriter addText(CharSequence var1) throws IOException;

    public XMLWriter addCData(CharSequence var1) throws IOException;

    public XMLWriter addAttribute(String var1, String var2) throws IOException;

    public XMLWriter addAttribute(String var1, int var2) throws IOException;

    default public XMLWriter addSimpleElement(String name, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        this.startOpenTag(name);
        this.endOpenTag();
        this.addText(value);
        this.closeTag(name, false);
        return this;
    }

    default public XMLWriter addSimpleElement(String name, String value, String lang) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        this.startOpenTag(name);
        this.addAttribute("xml:lang", lang);
        this.endOpenTag();
        this.addText(value);
        this.closeTag(name, false);
        return this;
    }

    default public XMLWriter addEmptyElement(String name) throws IOException {
        this.startOpenTag(name);
        this.closeEmptyTag();
        return this;
    }
}

