/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public class DefaultXMLWriter
implements AppendableXMLWriter {
    private Appendable appendable;
    private int indentLength = 0;
    private boolean aposEscaped = true;

    public void setAppendable(Appendable appendable) {
        this.appendable = appendable;
    }

    public Appendable getAppendable() {
        return this.appendable;
    }

    @Override
    public int getCurrentIndentValue() {
        return this.indentLength;
    }

    public void setIndentLength(int indentLength) {
        this.indentLength = indentLength;
    }

    public void increaseIndentValue() {
        ++this.indentLength;
    }

    public void decreaseIndentValue() {
        --this.indentLength;
    }

    public boolean isAposEscaped() {
        return this.aposEscaped;
    }

    public void setAposEscaped(boolean aposEscaped) {
        this.aposEscaped = aposEscaped;
    }

    @Override
    public DefaultXMLWriter appendXMLDeclaration() throws IOException {
        XMLUtils.appendXmlDeclaration(this);
        return this;
    }

    @Override
    public DefaultXMLWriter addEmptyElement(String tagname) throws IOException {
        return (DefaultXMLWriter)AppendableXMLWriter.super.addEmptyElement(tagname);
    }

    @Override
    public DefaultXMLWriter addSimpleElement(String tagname, String value) throws IOException {
        return (DefaultXMLWriter)AppendableXMLWriter.super.addSimpleElement(tagname, value);
    }

    @Override
    public DefaultXMLWriter addSimpleElement(String tagname, String value, String lang) throws IOException {
        return (DefaultXMLWriter)AppendableXMLWriter.super.addSimpleElement(tagname, value, lang);
    }

    @Override
    public DefaultXMLWriter startOpenTag(String name) throws IOException {
        this.startOpenTag(name, true);
        return this;
    }

    @Override
    public DefaultXMLWriter startOpenTag(String name, boolean indentBefore) throws IOException {
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append(name);
        return this;
    }

    @Override
    public DefaultXMLWriter endOpenTag() throws IOException {
        this.append('>');
        this.increaseIndentValue();
        return this;
    }

    @Override
    public DefaultXMLWriter closeEmptyTag() throws IOException {
        this.append('/');
        this.append('>');
        return this;
    }

    @Override
    public DefaultXMLWriter openTag(String name) throws IOException {
        this.openTag(name, true);
        return this;
    }

    @Override
    public DefaultXMLWriter openTag(String name, boolean indentBefore) throws IOException {
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append(name);
        this.append('>');
        this.increaseIndentValue();
        return this;
    }

    @Override
    public DefaultXMLWriter closeTag(String name) throws IOException {
        this.closeTag(name, true);
        return this;
    }

    @Override
    public DefaultXMLWriter closeTag(String name, boolean indentBefore) throws IOException {
        this.decreaseIndentValue();
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append('/');
        this.append(name);
        this.append('>');
        return this;
    }

    @Override
    public DefaultXMLWriter addText(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            return this;
        }
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            char carac = charSequence.charAt(i);
            this.escape(carac);
        }
        return this;
    }

    private void escape(char carac) throws IOException {
        if (carac < ' ') {
            this.append(' ');
        } else {
            switch (carac) {
                case '&': {
                    this.append("&amp;");
                    break;
                }
                case '\"': {
                    this.append("&quot;");
                    break;
                }
                case '\'': {
                    if (this.aposEscaped) {
                        this.append("&apos;");
                        break;
                    }
                    this.append(carac);
                    break;
                }
                case '<': {
                    this.append("&lt;");
                    break;
                }
                case '>': {
                    this.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    this.append("&#x00A0;");
                    break;
                }
                case '\u202f': {
                    this.append("&#x202F;");
                    break;
                }
                default: {
                    this.append(carac);
                }
            }
        }
    }

    @Override
    public DefaultXMLWriter append(char c) throws IOException {
        this.appendable.append(c);
        return this;
    }

    @Override
    public DefaultXMLWriter append(CharSequence charSequence) throws IOException {
        this.appendable.append(charSequence);
        return this;
    }

    @Override
    public DefaultXMLWriter append(CharSequence charSequence, int start, int end) throws IOException {
        this.appendable.append(charSequence, start, end);
        return this;
    }

    @Override
    public DefaultXMLWriter addCData(CharSequence charSequence) throws IOException {
        this.appendable.append("<![CDATA[");
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            char carac = charSequence.charAt(i);
            if (carac == ']') {
                if (i < length - 1 && charSequence.charAt(i + 1) == ']') {
                    this.appendable.append("]]>");
                    this.appendable.append("]]");
                    this.appendable.append("<![CDATA[");
                    ++i;
                    continue;
                }
                this.appendable.append(']');
                continue;
            }
            this.appendable.append(carac);
        }
        this.appendable.append("]]>");
        return this;
    }

    @Override
    public DefaultXMLWriter appendIndent() throws IOException {
        if (this.indentLength > -1) {
            this.append('\n');
            for (int i = 0; i < this.indentLength; ++i) {
                this.append('\t');
            }
        }
        return this;
    }

    @Override
    public DefaultXMLWriter addAttribute(String attributeName, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.addText(value);
        this.append('\"');
        return this;
    }

    @Override
    public DefaultXMLWriter addAttribute(String attributeName, int i) throws IOException {
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.append(String.valueOf(i));
        this.append('\"');
        return this;
    }
}

