/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.Set;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.SubstringPosition;

public final class StringUtils {
    public static final String[] EMPTY_STRINGARRAY = new String[0];
    public static final List<String> EMPTY_STRINGLIST = Collections.emptyList();
    public static final Set<String> EMPTY_STRINGSET = Collections.emptySet();
    public static final List<RelativePath> EMPTY_RELATIVEPATHLIST = Collections.emptyList();
    public static final short NOTCLEAN = 0;
    public static final short EMPTY_INCLUDE = 1;
    public static final short EMPTY_EXCLUDE = 2;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String CHAR_SEQUENCE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private StringUtils() {
    }

    public static boolean isTrue(String text) {
        return StringUtils.toBoolean(text, false);
    }

    public static boolean toBoolean(String text, boolean defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        switch (text = text.trim().toLowerCase()) {
            case "1": 
            case "true": 
            case "yes": 
            case "oui": 
            case "si": {
                return true;
            }
            case "0": 
            case "false": 
            case "no": 
            case "non": {
                return false;
            }
        }
        return defaultValue;
    }

    public static String getFirstPart(String text) {
        int idx = text.indexOf(59);
        if (idx == -1) {
            return text;
        }
        return text.substring(0, idx);
    }

    public static String normalizeRelativePath(String path) {
        return StringUtils.normalizeRelativePath(path, false);
    }

    public static String normalizeRelativePath(String path, boolean allowsParentSegment) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return null;
            }
            uri = uri.normalize();
            String result = uri.getPath();
            if (!allowsParentSegment && result.startsWith("../")) {
                return null;
            }
            if (result.startsWith("/")) {
                return null;
            }
            if (result.length() == 0) {
                return null;
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        catch (URISyntaxException use) {
            return null;
        }
    }

    public static String[] getTechnicalTokens(String s, boolean includeSpace) {
        return StringUtils.getTechnicalTokens(s, includeSpace ? "[ \n\r\t;,]" : "[\n\r\t;,]");
    }

    public static String[] getTechnicalTokens(String s, char separateur, boolean includeSpace) {
        StringBuilder buf = new StringBuilder();
        buf.append("[\n\r\t");
        buf.append(separateur);
        if (includeSpace) {
            buf.append(" ");
        }
        buf.append("]");
        return StringUtils.getTechnicalTokens(s, buf.toString());
    }

    private static String[] getTechnicalTokens(String s, String splitString) {
        String[] tokens = s.split(splitString);
        int p = 0;
        for (String token : tokens) {
            String val = StringUtils.cleanString(token);
            if (val.length() <= 0) continue;
            tokens[p] = val;
            ++p;
        }
        if (p < tokens.length) {
            String[] result = new String[p];
            System.arraycopy(tokens, 0, result, 0, p);
            tokens = result;
        }
        return tokens;
    }

    public static String[] getLineTokens(String chaine, short cleanType) {
        int size;
        if (chaine == null || chaine.length() == 0) {
            return EMPTY_STRINGARRAY;
        }
        ArrayList<String> ps = new ArrayList<String>();
        BufferedReader buflect = new BufferedReader(new StringReader(chaine));
        try {
            String ligne;
            while ((ligne = buflect.readLine()) != null) {
                if (cleanType != 0) {
                    ligne = StringUtils.cleanString(ligne);
                    if (cleanType != 1 && ligne.length() <= 0) continue;
                    ps.add(ligne);
                    continue;
                }
                ps.add(ligne);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((size = ps.size()) == 0) {
            return EMPTY_STRINGARRAY;
        }
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)ps.get(i);
        }
        return result;
    }

    public static String[] getTokens(String chaine, char separateur, short cleanType) {
        int size;
        if (chaine == null || chaine.length() == 0) {
            return EMPTY_STRINGARRAY;
        }
        ArrayList<String> ps = new ArrayList<String>();
        int length = chaine.length();
        int lastIndex = 0;
        for (int i = 0; i < length; ++i) {
            char carac = chaine.charAt(i);
            if (carac != separateur) continue;
            if (i == lastIndex) {
                if (cleanType != 2) {
                    ps.add("");
                }
            } else {
                String token = chaine.substring(lastIndex, i);
                if (cleanType != 0) {
                    token = StringUtils.cleanString(token);
                    if (cleanType == 1 || token.length() > 0) {
                        ps.add(token);
                    }
                } else {
                    ps.add(token);
                }
            }
            lastIndex = i + 1;
        }
        if (lastIndex < length) {
            String token = chaine.substring(lastIndex);
            if (cleanType != 0) {
                token = StringUtils.cleanString(token);
                if (cleanType == 1 || token.length() > 0) {
                    ps.add(token);
                }
            } else {
                ps.add(token);
            }
        }
        if ((size = ps.size()) == 0) {
            return EMPTY_STRINGARRAY;
        }
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)ps.get(i);
        }
        return result;
    }

    public static boolean isAbsoluteUrlString(String s) {
        int length = s.length();
        block4: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '+': 
                case '-': 
                case '.': {
                    if (i != 0) continue block4;
                    return false;
                }
                case ':': {
                    if (i == 0) {
                        return false;
                    }
                    if (i == length - 1) {
                        return false;
                    }
                    return s.charAt(i + 1) == '/';
                }
                default: {
                    if (carac >= '0' && carac <= '9') {
                        if (i != 0) continue block4;
                        return false;
                    }
                    if (carac >= 'a' && carac <= 'z' || carac >= 'A' && carac <= 'Z') continue block4;
                    return false;
                }
            }
        }
        return false;
    }

    public static IntAndString parseIntAndString(String s) throws ParseException {
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        int id = 0;
        String value = "";
        int length = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char carac = s.charAt(i);
            int p = StringUtils.testChar(carac);
            if (p == -1) {
                char carac2;
                if (i == 0) {
                    throw new ParseException("first character is not a number", 0);
                }
                int index = i;
                for (int j = i; j < length && (carac2 = s.charAt(j)) == ' '; ++j) {
                    index = j + 1;
                }
                if (index == length) {
                    value = "";
                    break;
                }
                switch (s.charAt(index)) {
                    case '\t': 
                    case ',': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '|': {
                        value = s.substring(index + 1);
                        break;
                    }
                    default: {
                        value = s.substring(index);
                    }
                }
                value = StringUtils.cleanString(value);
                break;
            }
            id = id * 10 + p;
        }
        return new IntAndString(id, value);
    }

    private static int testChar(char carac) {
        if (carac < '0' || carac > '9') {
            return -1;
        }
        return carac - 48;
    }

    public static boolean isCleanString(String s) {
        if (s == null) {
            return true;
        }
        String cleanedString = StringUtils.cleanString(s);
        return cleanedString.equals(s);
    }

    public static String cleanString(CharSequence s) {
        return StringUtils.cleanString(s, true);
    }

    public static boolean isBlankString(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        int taille = charSequence.length();
        if (taille == 0) {
            return true;
        }
        for (int i = 0; i < taille; ++i) {
            char carac = charSequence.charAt(i);
            if (carac <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String cleanString(CharSequence charSequence, boolean trim) {
        if (charSequence == null) {
            return null;
        }
        int taille = charSequence.length();
        if (taille == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(taille);
        boolean debut = true;
        boolean avecblanc = false;
        for (int i = 0; i < taille; ++i) {
            char carac = charSequence.charAt(i);
            if (carac <= ' ') {
                if (!debut) {
                    avecblanc = true;
                    continue;
                }
                if (trim) continue;
                avecblanc = true;
                continue;
            }
            debut = false;
            if (avecblanc) {
                buf.append(' ');
                avecblanc = false;
            }
            buf.append(carac);
        }
        if (!trim && avecblanc) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String reduceToLetterAndDigit(String source) {
        int length = source.length();
        if (length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(length + 10);
        for (int i = 0; i < length; ++i) {
            char carac = source.charAt(i);
            if (Character.isLetter(carac)) {
                buf.append(carac);
                continue;
            }
            if (!Character.isDigit(carac)) continue;
            int val = Character.getNumericValue(carac);
            if (val < 0) {
                buf.append(carac);
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public static String[] wrap(String s, int l) {
        if (s.length() <= l || l < 1) {
            String[] lineArray = new String[]{s.length() == 0 ? " " : s};
            return lineArray;
        }
        String line = s;
        boolean p = false;
        ArrayList<String> lineList = new ArrayList<String>();
        while (line != null) {
            if (line.length() <= l) {
                lineList.add(line);
                break;
            }
            if (Character.isWhitespace(line.charAt(l))) {
                lineList.add(line.substring(0, l));
                if (line.length() == l + 1) break;
                line = line.substring(l + 1);
                continue;
            }
            boolean coupure = false;
            for (int q = l - 1; q > 0; --q) {
                char car = line.charAt(q);
                if (car == '-') {
                    lineList.add(line.substring(0, q + 1));
                    line = line.substring(q + 1);
                    coupure = true;
                    break;
                }
                if (!Character.isWhitespace(car)) continue;
                lineList.add(line.substring(0, q));
                line = line.substring(q + 1);
                coupure = true;
                break;
            }
            if (coupure) continue;
            lineList.add(line.substring(0, l));
            line = line.substring(l);
        }
        return lineList.toArray(new String[lineList.size()]);
    }

    public static String[] wrap(String s, int l, int lineMax) {
        if (s.length() <= l || l < 1) {
            String[] lineArray = new String[]{s.length() == 0 ? " " : s};
            return lineArray;
        }
        String line = s;
        int lineNumber = 0;
        ArrayList<String> lineList = new ArrayList<String>();
        while (line != null) {
            if (line.length() <= l) {
                lineList.add(line);
                break;
            }
            if (Character.isWhitespace(line.charAt(l))) {
                lineList.add(line.substring(0, l));
                if (line.length() == l + 1) break;
                line = line.substring(l + 1);
            } else {
                boolean coupure = false;
                for (int q = l - 1; q > 0; --q) {
                    char car = line.charAt(q);
                    if (car == '-') {
                        lineList.add(line.substring(0, q + 1));
                        line = line.substring(q + 1);
                        coupure = true;
                        break;
                    }
                    if (!Character.isWhitespace(car)) continue;
                    lineList.add(line.substring(0, q));
                    line = line.substring(q + 1);
                    coupure = true;
                    break;
                }
                if (!coupure) {
                    lineList.add(line.substring(0, l));
                    line = line.substring(l);
                }
            }
            if (lineMax <= 0 || ++lineNumber != lineMax) continue;
            String lastLine = (String)lineList.get(lineList.size() - 1);
            lastLine = lastLine + "...";
            lineList.set(lineList.size() - 1, lastLine);
            break;
        }
        return lineList.toArray(new String[lineList.size()]);
    }

    public static String getRandomToken(int length) {
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            buf.append(CHAR_SEQUENCE.charAt(SECURE_RANDOM.nextInt(CHAR_SEQUENCE.length())));
        }
        return buf.toString();
    }

    public static boolean isUUID(String uuid) {
        if (uuid == null) {
            return false;
        }
        if (uuid.length() != 36) {
            return false;
        }
        for (int i = 0; i < 36; ++i) {
            char carac = uuid.charAt(i);
            if (!(i == 8 || i == 13 || i == 18 || i == 23 ? carac != '-' : !(carac >= 'a' && carac <= 'f' || carac >= '0' && carac <= '9'))) continue;
            return false;
        }
        return true;
    }

    public static void checkTechnicalName(String s, boolean underscoreAllowed) throws ParseException {
        if (s == null) {
            throw new ParseException("string argument is null", 0);
        }
        int longueur = s.length();
        if (longueur < 2) {
            throw new ParseException("string length < 2", 1);
        }
        for (int i = 0; i < longueur; ++i) {
            char carac = s.charAt(i);
            if (i == 0 && carac >= '0' && carac <= '9') {
                throw new ParseException("starts with a number", 0);
            }
            if (carac == '_') {
                if (underscoreAllowed) {
                    if (i != 0) continue;
                    throw new ParseException("starts with an underscore", 0);
                }
                throw new ParseException("underscore _ is not allowed", i);
            }
            if (carac >= 'a' && carac <= 'z' || carac >= '0' && carac <= '9') continue;
            throw new ParseException("bar character : " + String.valueOf(carac), i);
        }
    }

    public static boolean isTechnicalName(String s, boolean underscoreAllowed) {
        try {
            StringUtils.checkTechnicalName(s, underscoreAllowed);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isAuthority(String s) {
        try {
            StringUtils.checkAuthority(s);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static String nullTrim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static void checkAuthority(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("string argument is null", 0);
        }
        int length = s.length();
        if (length == 0) {
            throw new ParseException("string argument is empty", 0);
        }
        block3: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '-': 
                case '.': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (carac >= 'a' && carac <= 'z' || carac >= 'A' && carac <= 'Z' || carac >= '0' && carac <= '9') continue block3;
                    throw new ParseException("bar character : " + String.valueOf(carac), i);
                }
            }
        }
    }

    public static void checkScriptName(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("string argument is null", 0);
        }
        int length = s.length();
        if (length == 0) {
            throw new ParseException("string argument is empty", 0);
        }
        block3: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            if (i == 0) {
                if (carac >= 'a' && carac <= 'z') continue;
                throw new ParseException("starts with : " + carac, 0);
            }
            switch (carac) {
                case '-': 
                case '.': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (carac >= 'a' && carac <= 'z' || carac >= '0' && carac <= '9') continue block3;
                    throw new ParseException("bar character : " + String.valueOf(carac), i);
                }
            }
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        int i;
        StringBuilder buf = new StringBuilder(1024);
        char[] bufArray = new char[1024];
        InputStreamReader isr = new InputStreamReader(inputStream, "UTF-8");
        while ((i = isr.read(bufArray)) != -1) {
            buf.append(bufArray, 0, i);
            if (i >= 1024) continue;
            break;
        }
        return buf.toString();
    }

    public static String toString(int integer, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        return numberFormat.format(integer);
    }

    public static String formatMessage(String messageString, Object value, Locale formatLocale) throws FormatException {
        Object[] objs;
        if (value == null) {
            return messageString;
        }
        if (value.getClass().isArray()) {
            objs = (Object[])value;
            if (objs.length == 0) {
                return messageString;
            }
        } else {
            objs = new Object[]{value};
        }
        try {
            MessageFormat messageFormat = new MessageFormat(messageString, formatLocale);
            return messageFormat.format(objs);
        }
        catch (IllegalArgumentException iae) {
            throw new FormatException(iae.getLocalizedMessage());
        }
    }

    public static SubstringPosition getSubstringPosition(String source, String part) {
        int idx = source.indexOf(part);
        if (idx == -1) {
            return null;
        }
        return new SubstringPosition(idx, part.length());
    }

    public static SubstringPosition getSubstringPosition(String source, String part, int type) {
        int partLength = part.length();
        switch (type) {
            case 3: {
                int idx = source.indexOf(part);
                if (idx != -1) {
                    return new SubstringPosition(idx, partLength);
                }
                return null;
            }
            case 0: {
                if (source.equals(part)) {
                    return new SubstringPosition(0, partLength);
                }
                return null;
            }
            case 2: {
                if (source.endsWith(part)) {
                    return new SubstringPosition(source.length() - partLength, partLength);
                }
                return null;
            }
            case 1: {
                if (source.startsWith(part)) {
                    return new SubstringPosition(0, partLength);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    public static boolean contains(String source, String part, int type) {
        switch (type) {
            case 3: {
                int idx = source.indexOf(part);
                return idx != -1;
            }
            case 0: {
                return source.equals(part);
            }
            case 2: {
                return source.endsWith(part);
            }
            case 1: {
                return source.startsWith(part);
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    public static int getIndent(String text) {
        int indent = 0;
        int textLength = text.length();
        boolean previous = false;
        for (int j = 0; j < textLength; ++j) {
            char carac = text.charAt(j);
            if (carac == ' ') {
                if (previous) {
                    previous = false;
                    ++indent;
                    continue;
                }
                previous = true;
                continue;
            }
            if (carac != '\t') break;
            ++indent;
            previous = false;
        }
        return indent;
    }

    public short getEMPTY_EXCLUDE() {
        return 2;
    }

    public static String escapeDoubleQuote(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length() + 20);
        StringUtils.escapeDoubleQuote(s, buf);
        return buf.toString();
    }

    public static void escapeDoubleQuote(String s, Appendable buf) {
        if (s == null) {
            return;
        }
        int length = s.length();
        try {
            for (int i = 0; i < length; ++i) {
                char carac = s.charAt(i);
                if (carac == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                if (carac == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                buf.append(carac);
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static String charToString(char carac) {
        switch (carac) {
            case '\t': {
                return "{TAB}";
            }
            case '\n': {
                return "{NL}";
            }
            case '\r': {
                return "{CR}";
            }
            case ' ': {
                return "{SPACE}";
            }
            case '\u00a0': {
                return "{NBSP}";
            }
        }
        StringBuilder buf = new StringBuilder();
        if (Character.isISOControl(carac)) {
            buf.append("{x");
            buf.append(Integer.toHexString(carac).toUpperCase());
            buf.append("}");
        } else {
            buf.append(carac);
        }
        return buf.toString();
    }

    public static char stringToChar(String s) {
        int length = s.length();
        if (length == 0) {
            throw new IllegalArgumentException("s is empty");
        }
        if (s.equals("{TAB}")) {
            return '\t';
        }
        if (s.equals("{NL}")) {
            return '\n';
        }
        if (length != 1) {
            throw new IllegalArgumentException("s is too long");
        }
        return s.charAt(0);
    }

    public static String[] toStringArray(char[] caracs) {
        int length = caracs.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = StringUtils.charToString(caracs[i]);
        }
        return result;
    }

    public static String[] toStringArray(CharSequence charSequence) {
        int length = charSequence.length();
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = StringUtils.charToString(charSequence.charAt(i));
        }
        return result;
    }

    public static String implode(String[] stringArray, char delim) {
        int length = stringArray.length;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(stringArray[i]);
        }
        return buf.toString();
    }

    public static String implode(Collection<String> values, char delim) {
        if (values.isEmpty()) {
            return "";
        }
        boolean next = false;
        StringBuilder buf = new StringBuilder();
        for (String value : values) {
            if (next) {
                buf.append(delim);
            } else {
                next = true;
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public static int testNumberChar(char carac) {
        if (carac < '0' || carac > '9') {
            return -1;
        }
        return carac - 48;
    }

    public static boolean isValidAsciiChar(char carac) {
        if (carac > '~') {
            return false;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        switch (carac) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '?': 
            case '@': 
            case '_': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidFirstAsciiChar(char carac) {
        if (carac > '~') {
            return false;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        switch (carac) {
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidAsciiString(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (StringUtils.isValidAsciiChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static double parseDouble(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException("empty");
        }
        DoubleParser doubleParser = new DoubleParser();
        return doubleParser.parse(s);
    }

    public static Decimal parseDecimal(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException("empty");
        }
        DecimalParser decimalParser = new DecimalParser();
        return decimalParser.parse(s);
    }

    public static BigDecimal parseBigDecimal(String s) throws NumberFormatException {
        Decimal decimal = StringUtils.parseDecimal(s);
        return decimal.toBigDecimal();
    }

    public static Decimal parseStrictDecimal(String decimalString) throws NumberFormatException {
        String partieEntiereString = decimalString;
        String partieDecimaleString = "";
        int idx = decimalString.indexOf(46);
        if (idx != -1) {
            partieEntiereString = decimalString.substring(0, idx);
            partieDecimaleString = decimalString.substring(idx + 1);
        }
        return StringUtils.parseDecimal(partieEntiereString, partieDecimaleString);
    }

    public static Decimal parseDecimal(String partieEntiereString, String partieDecimaleString) throws NumberFormatException {
        long partieEntiere = 0L;
        boolean negatif = false;
        if (partieEntiereString.length() > 0) {
            partieEntiere = Long.parseLong(partieEntiereString);
            if (partieEntiere < 0L) {
                negatif = true;
            } else if (partieEntiere == 0L && partieEntiereString.charAt(0) == '-') {
                negatif = true;
            }
        }
        int partieDecimale = 0;
        int zeroLength = 0;
        int length = partieDecimaleString.length();
        if (length > 0) {
            if (length > 9) {
                partieDecimaleString = partieDecimaleString.substring(0, 9);
            }
            for (int i = 0; i < length && partieDecimaleString.charAt(i) == '0'; ++i) {
                ++zeroLength;
            }
            partieDecimale = Integer.parseInt(partieDecimaleString);
        }
        if (negatif) {
            partieDecimale = -partieDecimale;
        }
        Decimal decimal = new Decimal(partieEntiere, (byte)zeroLength, partieDecimale);
        return decimal;
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            if (carac <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String toMD5(String s) {
        try {
            return StringUtils.digest("MD5", s);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    public static String digest(String algorithm, String s) throws NoSuchAlgorithmException {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance(algorithm);
            msgDigest.update(s.getBytes("UTF-8"));
            byte[] digest = msgDigest.digest();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    result.append('0');
                }
                result.append(hex);
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    public static String getMD5Checksum(File file) throws IOException {
        try {
            return StringUtils.getFileChecksum(MessageDigest.getInstance("MD5"), file);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    private static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String getReversePath(String path) {
        int length = path.length();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (path.charAt(i) != '/') continue;
            buf.append("../");
        }
        return buf.toString();
    }

    public static List<String> wrap(String[] array) {
        return new StringList(array);
    }

    public static List<String> toList(Collection<String> collection) {
        int size = collection.size();
        if (size == 0) {
            return EMPTY_STRINGLIST;
        }
        return new StringList(collection.toArray(new String[size]));
    }

    public static MultiStringable toMultiStringable(Collection<String> collection) {
        String[] array = collection.toArray(new String[collection.size()]);
        return new StringMultiStringable(array);
    }

    public static List<URL> wrap(URL[] array) {
        return new URLList(array);
    }

    public static List<RelativePath> wrap(RelativePath[] array) {
        return new RelativePathList(array);
    }

    public static List<Object> wrap(Object[] array) {
        return new ObjectList(array);
    }

    public static class IntAndString {
        private final int i;
        private final String s;

        IntAndString(int i, String s) {
            this.i = i;
            this.s = s;
        }

        public int getInt() {
            return this.i;
        }

        public String getString() {
            return this.s;
        }
    }

    public static class FormatException
    extends Exception {
        private FormatException(String message) {
            super(message);
        }
    }

    private static class DoubleParser {
        boolean negatif;

        DoubleParser() {
        }

        double parse(String s) {
            int startIndex;
            int length = s.length();
            int[] chiffres = new int[length];
            int currentIndex = 0;
            int decimalIndex = -1;
            char decimalCar = '?';
            boolean forceDecimal = false;
            block5: for (int i = startIndex = this.testNegatif(s.charAt(0), length); i < length; ++i) {
                char carac = s.charAt(i);
                switch (carac) {
                    case ' ': {
                        continue block5;
                    }
                    case ',': 
                    case '.': {
                        if (forceDecimal) {
                            throw new NumberFormatException("For input :  " + s);
                        }
                        if (decimalIndex == -1) {
                            decimalIndex = currentIndex;
                            decimalCar = carac;
                            continue block5;
                        }
                        if (carac == decimalCar) {
                            decimalIndex = -9;
                            continue block5;
                        }
                        if (carac == decimalCar) continue block5;
                        forceDecimal = true;
                        decimalIndex = currentIndex;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        chiffres[currentIndex] = carac - 48;
                        ++currentIndex;
                        continue block5;
                    }
                    default: {
                        throw new NumberFormatException("For input :  " + s);
                    }
                }
            }
            int chiffreLength = currentIndex;
            if (decimalIndex < 0) {
                decimalIndex = chiffreLength;
            }
            double resultat = 0.0;
            for (int i = 0; i < decimalIndex; ++i) {
                resultat = resultat * 10.0 + (double)chiffres[i];
            }
            if (decimalIndex < chiffreLength) {
                double dizaines = 10.0;
                for (int i = decimalIndex; i < chiffreLength; ++i) {
                    resultat += (double)chiffres[i] / dizaines;
                    dizaines = 10.0 * dizaines;
                }
            }
            if (this.negatif) {
                return -resultat;
            }
            return resultat;
        }

        int testNegatif(char first, int length) {
            if (first == '-') {
                this.negatif = true;
                if (length == 1) {
                    throw new NumberFormatException("only - ");
                }
                return 1;
            }
            return 0;
        }
    }

    private static class DecimalParser {
        boolean negatif;

        DecimalParser() {
        }

        Decimal parse(String s) {
            int startIndex;
            int length = s.length();
            int[] chiffres = new int[length];
            int currentIndex = 0;
            int decimalIndex = -1;
            char decimalCar = '?';
            boolean forceDecimal = false;
            block5: for (int i = startIndex = this.testNegatif(s.charAt(0), length); i < length; ++i) {
                char carac = s.charAt(i);
                if (Character.isSpaceChar(carac)) continue;
                switch (carac) {
                    case '\'': {
                        continue block5;
                    }
                    case ',': 
                    case '.': {
                        if (forceDecimal) {
                            throw new NumberFormatException("For input :  " + s);
                        }
                        if (decimalIndex == -1) {
                            decimalIndex = currentIndex;
                            decimalCar = carac;
                            continue block5;
                        }
                        if (carac == decimalCar) {
                            decimalIndex = -9;
                            continue block5;
                        }
                        if (carac == decimalCar) continue block5;
                        forceDecimal = true;
                        decimalIndex = currentIndex;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        chiffres[currentIndex] = carac - 48;
                        ++currentIndex;
                        continue block5;
                    }
                    default: {
                        throw new NumberFormatException("For input :  " + s);
                    }
                }
            }
            int chiffreLength = currentIndex;
            if (decimalIndex < 0) {
                decimalIndex = chiffreLength;
            }
            long partieEntiere = 0L;
            for (int i = 0; i < decimalIndex; ++i) {
                partieEntiere = partieEntiere * 10L + (long)chiffres[i];
            }
            int partieDecimale = 0;
            int zeroLength = 0;
            if (decimalIndex < chiffreLength) {
                double dizaines = 10.0;
                boolean debut = true;
                int premierschiffres = Math.min(chiffreLength, decimalIndex + 9);
                for (int i = decimalIndex; i < premierschiffres; ++i) {
                    int chiffre = chiffres[i];
                    if (debut && chiffre == 0) {
                        ++zeroLength;
                        continue;
                    }
                    debut = false;
                    partieDecimale = partieDecimale * 10 + chiffre;
                }
            }
            if (this.negatif) {
                partieEntiere = -partieEntiere;
                partieDecimale = -partieDecimale;
            }
            Decimal decimal = new Decimal(partieEntiere, (byte)zeroLength, partieDecimale);
            return decimal;
        }

        int testNegatif(char first, int length) {
            if (first == '-') {
                this.negatif = true;
                if (length == 1) {
                    throw new NumberFormatException("only - ");
                }
                return 1;
            }
            return 0;
        }
    }

    private static class StringList
    extends AbstractList<String>
    implements RandomAccess {
        private final String[] array;

        private StringList(String[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public String get(int index) {
            return this.array[index];
        }
    }

    private static class StringMultiStringable
    implements MultiStringable {
        private final String[] array;

        private StringMultiStringable(String[] array) {
            this.array = array;
        }

        @Override
        public String[] toStringArray() {
            int size = this.array.length;
            String[] result = new String[size];
            System.arraycopy(this.array, 0, result, 0, size);
            return result;
        }

        @Override
        public int getStringSize() {
            return this.array.length;
        }

        @Override
        public String getStringValue(int index) {
            return this.array[index];
        }
    }

    private static class URLList
    extends AbstractList<URL>
    implements RandomAccess {
        private final URL[] array;

        private URLList(URL[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public URL get(int index) {
            return this.array[index];
        }
    }

    private static class RelativePathList
    extends AbstractList<RelativePath>
    implements RandomAccess {
        private final RelativePath[] array;

        private RelativePathList(RelativePath[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public RelativePath get(int index) {
            return this.array[index];
        }
    }

    private static class ObjectList
    extends AbstractList<Object>
    implements RandomAccess {
        private final Object[] array;

        private ObjectList(Object[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }
    }
}

