/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;

public class LabelsCache {
    private final Map<Lang, Label> labelMap = new LinkedHashMap<Lang, Label>();
    private Labels cachedLabels;

    public synchronized void clear() {
        this.labelMap.clear();
        this.cachedLabels = null;
    }

    public synchronized void putLabels(Labels labels) {
        for (Label label : labels) {
            this.labelMap.put(label.getLang(), label);
        }
        this.cachedLabels = null;
    }

    public synchronized boolean putLabel(Label label) {
        Lang lang = label.getLang();
        Label current = this.labelMap.get(lang);
        if (current != null && LabelUtils.areEquals(current, label)) {
            return false;
        }
        this.labelMap.put(lang, label);
        this.cachedLabels = null;
        return true;
    }

    public synchronized boolean removeLabel(Lang lang) {
        Label label = this.labelMap.remove(lang);
        if (label != null) {
            this.cachedLabels = null;
            return true;
        }
        return false;
    }

    public Labels getLabels() {
        Labels result = this.cachedLabels;
        if (result == null) {
            result = this.cache();
        }
        return result;
    }

    private synchronized Labels cache() {
        Labels cache;
        this.cachedLabels = cache = LabelUtils.toLabels(this.labelMap);
        return cache;
    }
}

