/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.text.ParseException;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.text.StringUtils;

public class RangeUtils {
    private RangeUtils() {
    }

    public static boolean isPositiveRanges(Ranges ranges) {
        return ranges.getGlobalMin() >= 0;
    }

    public static String positiveRangesToString(Ranges ranges) {
        return RangeUtils.positiveRangesToString(ranges, ";");
    }

    public static String positiveRangesToString(Ranges ranges, String separator) {
        if (ranges.getGlobalMin() < 0) {
            throw new IllegalArgumentException("not a positive range");
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < ranges.size(); ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            RangeUtils.appendRange(buf, ranges.get(i));
        }
        return buf.toString();
    }

    public static String positiveRangetoString(Range range) {
        StringBuilder buf = new StringBuilder();
        RangeUtils.appendRange(buf, range);
        return buf.toString();
    }

    public static void appendRange(StringBuilder buf, Range range) {
        int max;
        int min = range.min();
        if (min == (max = range.max())) {
            buf.append(min);
            return;
        }
        if (min != 0) {
            buf.append(min);
        }
        buf.append('-');
        if (max != Integer.MAX_VALUE) {
            buf.append(max);
        }
    }

    public static Ranges positiveRangeParse(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Ranges ranges = new Ranges();
        for (String token : StringUtils.getTechnicalTokens(s, false)) {
            try {
                Range range = RangeUtils.parseRange(token);
                if (range == null) continue;
                ranges.addRange(range);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (ranges.size() == 0) {
            return null;
        }
        return ranges;
    }

    public static Range parseRange(String token) throws ParseException {
        int idx = token.indexOf(45);
        if (idx == -1) {
            int num = RangeUtils.parseInt(token);
            if (num < 0) {
                return null;
            }
            return new Range(num, num);
        }
        int num1 = RangeUtils.parseInt(token.substring(0, idx));
        int num2 = RangeUtils.parseInt(token.substring(idx + 1));
        if (num1 < 0) {
            if (num2 < 0) {
                return null;
            }
            return new Range(0, num2);
        }
        if (num2 < 0) {
            return new Range(num1, Integer.MAX_VALUE);
        }
        return new Range(num1, num2);
    }

    private static int parseInt(String token) throws ParseException {
        int length = token.length();
        boolean done = false;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            char carac = token.charAt(i);
            if (carac == ' ') continue;
            if (carac >= '0' && carac <= '9') {
                result *= 10;
                result += carac - 48;
                done = true;
                continue;
            }
            throw new ParseException("Not a number: " + token, i);
        }
        if (!done) {
            return -1;
        }
        return result;
    }
}

