/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.mimetype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.text.StringUtils;

public class MimeTypeResolverBuilder {
    private final Map<String, String> mimeTypeByExtensionMap = new HashMap<String, String>();
    private final Map<String, String> extensionByMimeTypeMap = new HashMap<String, String>();

    public MimeTypeResolver toMimeTypeResolver() {
        return new InternalMimeTypeResolver(this.mimeTypeByExtensionMap, this.extensionByMimeTypeMap);
    }

    public void parseLine(String lineString) {
        int length = (lineString = lineString.trim()).length();
        if (length == 0) {
            return;
        }
        if (lineString.startsWith("#")) {
            return;
        }
        StringBuilder mimeTypeBuilder = new StringBuilder();
        int whiteCarac = -1;
        for (int i = 0; i < length; ++i) {
            char carac = lineString.charAt(i);
            if (Character.isWhitespace(carac)) {
                whiteCarac = i;
                break;
            }
            mimeTypeBuilder.append(carac);
        }
        if (whiteCarac == -1) {
            return;
        }
        String extensionString = lineString.substring(whiteCarac).trim();
        String[] tokens = StringUtils.getTokens(extensionString, ' ', (short)2);
        String mimeType = mimeTypeBuilder.toString();
        String firstExtension = tokens[0];
        if (!this.extensionByMimeTypeMap.containsKey(mimeType)) {
            this.extensionByMimeTypeMap.put(mimeType, firstExtension);
        }
        for (String token : tokens) {
            if (this.mimeTypeByExtensionMap.containsKey(token)) continue;
            this.mimeTypeByExtensionMap.put(token, mimeType);
        }
    }

    public void parse(Reader reader) throws IOException {
        String lineString;
        BufferedReader bufReader = new BufferedReader(reader);
        while ((lineString = bufReader.readLine()) != null) {
            this.parseLine(lineString);
        }
    }

    private static class InternalMimeTypeResolver
    implements MimeTypeResolver {
        private final Map<String, String> mimeTypeByExtensionMap;
        private final Map<String, String> extensionByMimeTypeMap;

        private InternalMimeTypeResolver(Map<String, String> mimeTypeByExtensionMap, Map<String, String> extensionByMimeTypeMap) {
            this.mimeTypeByExtensionMap = mimeTypeByExtensionMap;
            this.extensionByMimeTypeMap = extensionByMimeTypeMap;
        }

        @Override
        public String getMimeType(String extension) {
            String mimeType = this.mimeTypeByExtensionMap.get(extension);
            if (mimeType == null) {
                return "application/octet-stream";
            }
            return mimeType;
        }

        @Override
        public String getPreferredExtension(String mimeType) {
            return this.extensionByMimeTypeMap.get(mimeType);
        }
    }
}

