/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.io.IOException;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;

public class CommandMessageJsonProducer
implements JsonProducer {
    private final CommandMessage[] commandMessages;
    private final MessageLocalisation messageLocalisation;

    public CommandMessageJsonProducer(MessageLocalisation messageLocalisation, CommandMessage ... commandMessages) {
        if (commandMessages.length == 0) {
            throw new IllegalArgumentException("commandMessages is empty");
        }
        this.commandMessages = commandMessages;
        this.messageLocalisation = messageLocalisation;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        int length = this.commandMessages.length;
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("commandMessage");
        CommonJson.object(jw, this.commandMessages[length - 1], this.messageLocalisation);
        if (length > 1) {
            jw.key("otherCommandMessageArray");
            jw.array();
            for (int i = 0; i < length - 1; ++i) {
                CommonJson.object(jw, this.commandMessages[i], this.messageLocalisation);
            }
            jw.endArray();
        }
        jw.endObject();
    }
}

