/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.jslib;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.mapeadores.util.jslib.ThirdLib;
import net.mapeadores.util.text.StringUtils;

public class ThirdLibBuilder {
    private final String name;
    private final Set<String> extensionSet = new LinkedHashSet<String>();

    public ThirdLibBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public ThirdLibBuilder addExtension(String extensionName) {
        this.extensionSet.add(extensionName);
        return this;
    }

    public ThirdLib toThirdLib() {
        List<String> finalList = StringUtils.toList(this.extensionSet);
        return new InternalThirdLib(this.name, finalList);
    }

    public static ThirdLibBuilder init(String name) {
        return new ThirdLibBuilder(name);
    }

    private static class InternalThirdLib
    implements ThirdLib {
        private final String name;
        private final List<String> extensionNameList;

        public InternalThirdLib(String name, List<String> extensionNameList) {
            this.name = name;
            this.extensionNameList = extensionNameList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getExtensionNameList() {
            return this.extensionNameList;
        }
    }
}

