/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io.docstream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.DocStream;

public class StringDocStream
implements DocStream {
    private String mimeType = "text/plain";
    private byte[] byteArray;

    public StringDocStream(String s) {
        this(s, "text/plain");
    }

    public StringDocStream(String s, String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        try {
            this.byteArray = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ShouldNotOccurException(uee);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    @Override
    public int getLength() {
        return this.byteArray.length;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public long getLastModified() {
        return -1L;
    }
}

