/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exec;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.exec.ArgsDef;
import net.mapeadores.util.exec.ArgsUtils;
import net.mapeadores.util.exec.CommandDef;
import net.mapeadores.util.exec.ParameterDef;

public class ArgsDefBuilder {
    private final SortedMap<String, CommandDef> commandDefMap = new TreeMap<String, CommandDef>();
    private final SortedMap<Character, InternalParameterDef> parameterDefMap = new TreeMap<Character, InternalParameterDef>();

    public ArgsDefBuilder addCommandDef(CommandDef commandDef) {
        this.commandDefMap.put(commandDef.getName(), commandDef);
        return this;
    }

    public ArgsDefBuilder addParameter(char character, String titleLocKey, boolean requireValue) {
        this.parameterDefMap.put(Character.valueOf(character), new InternalParameterDef(character, titleLocKey, requireValue, null));
        return this;
    }

    public ArgsDefBuilder addParameter(char character, String titleLocKey, Collection<String> values) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(values);
        this.parameterDefMap.put(Character.valueOf(character), new InternalParameterDef(character, titleLocKey, true, set));
        return this;
    }

    public static ArgsDefBuilder init() {
        return new ArgsDefBuilder();
    }

    public ArgsDef toArgsDef() {
        List<ParameterDef> parameterDefList = ArgsUtils.wrap(this.parameterDefMap.values().toArray(new ParameterDef[this.parameterDefMap.size()]));
        HashMap<Character, InternalParameterDef> finalParameterDefMap = new HashMap<Character, InternalParameterDef>(this.parameterDefMap);
        List<CommandDef> commandDefList = ArgsUtils.wrap(this.commandDefMap.values().toArray(new CommandDef[this.commandDefMap.size()]));
        HashMap<String, CommandDef> finalCommandDefMap = new HashMap<String, CommandDef>(this.commandDefMap);
        return new InternalArgsDef(parameterDefList, finalParameterDefMap, commandDefList, finalCommandDefMap);
    }

    private static class InternalParameterDef
    implements ParameterDef {
        private final char letter;
        private final String titleLocKey;
        private final boolean requireValue;
        private final Set<String> valueSet;

        private InternalParameterDef(char letter, String titleLocKey, boolean requireValue, Set<String> valueSet) {
            this.letter = letter;
            this.titleLocKey = titleLocKey;
            this.requireValue = requireValue;
            this.valueSet = valueSet;
        }

        @Override
        public char getLetter() {
            return this.letter;
        }

        @Override
        public String getTitleLocKey() {
            return this.titleLocKey;
        }

        @Override
        public boolean requireValue() {
            return this.requireValue;
        }

        @Override
        public boolean isValidValue(String value) {
            if (!this.requireValue) {
                return false;
            }
            if (this.valueSet == null) {
                return true;
            }
            return this.valueSet.contains(value);
        }
    }

    private static class InternalArgsDef
    implements ArgsDef {
        private final List<ParameterDef> parameterDefList;
        private final Map<Character, ParameterDef> parameterDefMap;
        private final List<CommandDef> commandDefList;
        private final Map<String, CommandDef> commandDefMap;

        private InternalArgsDef(List<ParameterDef> parameterDefList, Map<Character, ParameterDef> parameterDefMap, List<CommandDef> commandDefList, Map<String, CommandDef> commandDefMap) {
            this.parameterDefList = parameterDefList;
            this.parameterDefMap = parameterDefMap;
            this.commandDefList = commandDefList;
            this.commandDefMap = commandDefMap;
        }

        @Override
        public ParameterDef getParameterDef(char letter) {
            return this.parameterDefMap.get(Character.valueOf(letter));
        }

        @Override
        public List<ParameterDef> getParameterDefList() {
            return this.parameterDefList;
        }

        @Override
        public CommandDef getCommandDef(String commandName) {
            return this.commandDefMap.get(commandName);
        }

        @Override
        public List<CommandDef> getCommandDefList() {
            return this.commandDefList;
        }
    }
}

