/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import net.mapeadores.util.exceptions.SwitchException;

public class TagNames {
    private final int extractVersion;

    public TagNames(int extractVersion) {
        this.extractVersion = extractVersion;
    }

    public String getTitleTagName() {
        if (this.extractVersion < 3) {
            return "titre";
        }
        return "title";
    }

    public String getSubtitleTagName() {
        if (this.extractVersion < 3) {
            return "soustitre";
        }
        return "subtitle";
    }

    public String getOwnersTagName() {
        if (this.extractVersion < 3) {
            return "redacteurs";
        }
        return "owners";
    }

    public String getPropTagName() {
        if (this.extractVersion < 3) {
            return "propriete";
        }
        return "prop";
    }

    public String getInfoTagName() {
        if (this.extractVersion < 3) {
            return "information";
        }
        return "info";
    }

    public String getTieTagName() {
        if (this.extractVersion < 3) {
            return "lien";
        }
        return "tie";
    }

    public String getSubsetTagName(short subsetCategory) {
        switch (this.extractVersion) {
            case 1: {
                switch (subsetCategory) {
                    case 1: {
                        return "extraitcorpus";
                    }
                    case 5: {
                        return "extraitalbum";
                    }
                    case 4: {
                        return "extraitaddenda";
                    }
                    case 2: {
                        return "extraitthesaurus";
                    }
                }
                throw new SwitchException("Unknown type: " + subsetCategory);
            }
        }
        switch (subsetCategory) {
            case 1: {
                return "fiches";
            }
            case 5: {
                return "illustrations";
            }
            case 4: {
                return "documents";
            }
            case 2: {
                return "motcles";
            }
        }
        throw new SwitchException("Unknown category: " + subsetCategory);
    }

    public String getSubsetTitleTagName() {
        switch (this.extractVersion) {
            case 1: {
                return "intitule";
            }
        }
        return "title";
    }

    public String getWeightAttributeName() {
        if (this.extractVersion < 3) {
            return "poids";
        }
        return "weight";
    }

    public String getPersonTagName() {
        if (this.extractVersion < 3) {
            return "personne";
        }
        return "person";
    }

    public String getNumberTagName() {
        if (this.extractVersion < 3) {
            return "nombre";
        }
        return "number";
    }

    public String getAmountTagName() {
        if (this.extractVersion < 3) {
            return "montant";
        }
        return "amount";
    }

    public String getLanguageTagName() {
        if (this.extractVersion < 3) {
            return "langue";
        }
        return "language";
    }

    public String getEmailTagName() {
        if (this.extractVersion < 3) {
            return "courriel";
        }
        return "email";
    }

    public String getCountryTagName() {
        if (this.extractVersion < 3) {
            return "pays";
        }
        return "country";
    }

    public String getDateTagName() {
        if (this.extractVersion < 3) {
            return "datation";
        }
        return "date";
    }
}

