/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.primitives.Ranges;

class MotcleRangeTestCache {
    private final Map<SubsetKey, Map<Integer, Boolean>> cacheMap = new HashMap<SubsetKey, Map<Integer, Boolean>>();
    private Map<Integer, Boolean> currentMap;
    private Thesaurus currentThesaurus;
    private final Ranges idRanges;
    private final Ranges levelRanges;

    MotcleRangeTestCache(Ranges levelRanges, Ranges idRanges) {
        this.levelRanges = levelRanges;
        this.idRanges = idRanges;
    }

    public void setCurrentThesaurus(Thesaurus thesaurus) {
        this.currentMap = this.cacheMap.get(thesaurus.getSubsetKey());
        if (this.currentMap == null) {
            this.currentMap = new HashMap<Integer, Boolean>();
            this.cacheMap.put(thesaurus.getSubsetKey(), this.currentMap);
        }
        this.currentThesaurus = thesaurus;
    }

    public boolean isSelected(Motcle motcle) {
        int id = motcle.getId();
        Boolean b = this.currentMap.get(id);
        if (b == null) {
            b = this.isRangeSelected(motcle) ? Boolean.TRUE : Boolean.FALSE;
            this.currentMap.put(id, b);
        }
        return b;
    }

    private boolean isRangeSelected(Motcle motcle) {
        if (this.levelRanges != null && !this.levelRanges.contains(motcle.getLevel())) {
            return false;
        }
        return this.idRanges == null || this.idRanges.contains(motcle.getId());
    }
}

