/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.reponderation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.tools.reponderation.ReponderationParameters;

public class ReponderationLog {
    public static final String ORIGIN_UNKNOWNSUBSET_ERROR = "origin_unknownsubset";
    public static final String CROISEMENT_UNKNOWNSUBSET_ERROR = "croisement_unknownsubset";
    public static final String MISSING_ORIGIN_ID_ERROR = "missing_origin_id_error";
    private final List<ReponderationError> errorList = new ArrayList<ReponderationError>();
    private final Map<String, ReponderationError> errorMap = new HashMap<String, ReponderationError>();
    private final List<ReponderationResult> resultList = new ArrayList<ReponderationResult>();
    private final ReponderationParameters reponderationParameters;

    ReponderationLog(ReponderationParameters reponderationParameters) {
        this.reponderationParameters = reponderationParameters;
    }

    public ReponderationParameters getReponderationParameters() {
        return this.reponderationParameters;
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public ReponderationError getError(int i) {
        return this.errorList.get(i);
    }

    public int getResultCount() {
        return this.resultList.size();
    }

    public ReponderationResult getResult(int i) {
        return this.resultList.get(i);
    }

    boolean hasError() {
        return !this.errorList.isEmpty();
    }

    void addErrorKey(String errorKey) {
        if (!this.errorMap.containsKey(errorKey)) {
            ReponderationError reponderationError = new ReponderationError(errorKey);
            this.errorList.add(reponderationError);
            this.errorMap.put(errorKey, reponderationError);
        }
    }

    void addIdError(String errorKey, int id) {
        ReponderationError reponderationError = this.errorMap.get(errorKey);
        if (reponderationError == null) {
            reponderationError = new ReponderationError(errorKey);
            this.errorList.add(reponderationError);
            this.errorMap.put(errorKey, reponderationError);
        }
        reponderationError.addId(id);
    }

    void addResult(int originId, int croisementId) {
        this.resultList.add(new ReponderationResult(originId, croisementId));
    }

    public static class ReponderationError {
        private final String errorKey;
        private final List<Integer> idList = new ArrayList<Integer>();

        private ReponderationError(String errorKey) {
            this.errorKey = errorKey;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public int getIdCount() {
            return this.idList.size();
        }

        public int getId(int i) {
            return this.idList.get(i);
        }

        private void addId(int id) {
            this.idList.add(id);
        }
    }

    public static class ReponderationResult {
        private final int originId;
        private final int croisementId;

        private ReponderationResult(int originId, int croisementId) {
            this.originId = originId;
            this.croisementId = croisementId;
        }

        public int getOriginId() {
            return this.originId;
        }

        public int getCroisementId() {
            return this.croisementId;
        }
    }
}

