/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import java.util.List;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.tools.parsers.LineInfo;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.text.StringUtils;

class UlParser
extends BlockParser {
    private final TextContentParser textContentParser;
    private UlBuffer rootUlBuffer;
    private UlBuffer currentUlBuffer;
    private Atts previousAtts = null;
    private final boolean withLineNumber;

    UlParser(TextContentParser textContentParser, boolean withLineNumber) {
        this.textContentParser = textContentParser;
        this.withLineNumber = withLineNumber;
    }

    @Override
    public boolean isStartLine(String line) {
        LineInfo lineInfo = LineInfo.parse(line, -1);
        return lineInfo.getCleanedLine().startsWith("-");
    }

    @Override
    public void parse(String[] lineArray, int startIndex, Atts initAtts) {
        this.rootUlBuffer = new UlBuffer(1, initAtts, null);
        this.previousAtts = null;
        this.currentUlBuffer = this.rootUlBuffer;
        int stop = lineArray.length - 1;
        for (int i = startIndex; i <= stop; ++i) {
            LineInfo lineInfo = LineInfo.parse(StringUtils.cleanString(lineArray[i]), this.withLineNumber ? i : -1);
            if (lineInfo.hasAttsError()) {
                stop = i - 1;
                break;
            }
            String cleanedLine = lineInfo.getCleanedLine();
            if (cleanedLine.startsWith("-")) {
                int tiretDepth = this.getTiretDepth(lineInfo);
                if (tiretDepth == 1 && this.hasPrevious()) {
                    stop = i - 2;
                    break;
                }
                this.addTiret(lineInfo, tiretDepth, i);
                continue;
            }
            if (this.hasPrevious()) {
                stop = i - 2;
                break;
            }
            if (cleanedLine.length() == 0) {
                this.previousAtts = lineInfo.getFirstAtts();
                continue;
            }
            if (cleanedLine.startsWith("_")) {
                this.addSouligne(lineInfo);
                continue;
            }
            stop = i - 1;
            break;
        }
        this.setParseResult(stop, this.rootUlBuffer.ul);
    }

    boolean hasPrevious() {
        return this.previousAtts != null && !this.previousAtts.hasOnlyAutomaticAtts();
    }

    int getTiretDepth(LineInfo lineInfo) {
        int depth;
        String cleanedLine = lineInfo.getCleanedLine();
        int availableDepth = cleanedLine.length();
        for (depth = 1; depth < availableDepth && cleanedLine.charAt(depth) == '-'; ++depth) {
        }
        return depth;
    }

    void addTiret(LineInfo lineInfo, int tiretDepth, int lineIndex) {
        int currentDepth = this.currentUlBuffer.depth;
        String cleanedLine = lineInfo.getCleanedLine();
        int nextDepth = currentDepth + 1;
        List<Atts> attsList = lineInfo.getAttsList();
        if (this.currentUlBuffer.isEmpty() && tiretDepth > currentDepth) {
            tiretDepth = currentDepth;
        } else if (tiretDepth > nextDepth) {
            tiretDepth = nextDepth;
        }
        P p = FicheBlockParser.parseP(cleanedLine.substring(tiretDepth).trim(), this.textContentParser);
        Atts secondAtts = lineInfo.getSecondAtts();
        if (secondAtts == null && this.withLineNumber) {
            secondAtts = LineInfo.getAutomaticAtts(lineIndex);
        }
        FicheUtils.populate(p, secondAtts);
        Li li = new Li(p);
        FicheUtils.populate(li, lineInfo.getFirstAtts());
        if (tiretDepth == currentDepth) {
            this.currentUlBuffer.addLi(li);
        } else if (tiretDepth == nextDepth) {
            UlBuffer ulBuffer = new UlBuffer(tiretDepth, this.previousAtts, this.currentUlBuffer);
            this.previousAtts = null;
            ulBuffer.addLi(li);
            this.currentUlBuffer.addUl(ulBuffer);
            this.currentUlBuffer = ulBuffer;
        } else {
            UlBuffer ancestor = this.getAncestor(tiretDepth);
            ancestor.addLi(li);
            this.currentUlBuffer = ancestor;
        }
    }

    private void addSouligne(LineInfo lineInfo) {
        int depth;
        int currentDepth = this.currentUlBuffer.depth;
        String cleanedLine = lineInfo.getCleanedLine();
        int availableDepth = cleanedLine.length();
        for (depth = 1; depth < availableDepth && cleanedLine.charAt(depth) == '_'; ++depth) {
        }
        if (depth > currentDepth) {
            depth = currentDepth;
        }
        P p = FicheBlockParser.parseP(cleanedLine.substring(depth).trim(), this.textContentParser);
        FicheUtils.populate(p, lineInfo.getFirstAtts());
        if (depth == currentDepth) {
            this.currentUlBuffer.addP(p);
        } else {
            UlBuffer ancestor = this.getAncestor(depth);
            ancestor.addP(p);
            this.currentUlBuffer = ancestor;
        }
    }

    private UlBuffer getAncestor(int depth) {
        UlBuffer parent = this.currentUlBuffer.parent;
        while (parent.depth > depth) {
            parent = parent.parent;
        }
        return parent;
    }

    private class UlBuffer {
        private final UlBuffer parent;
        private final int depth;
        private final Atts initAtts;
        private Ul ul = null;
        private Li lastLi;

        private UlBuffer(int depth, Atts initAtts, UlBuffer parent) {
            this.depth = depth;
            this.parent = parent;
            this.initAtts = initAtts;
        }

        private boolean isEmpty() {
            return this.ul == null;
        }

        private void addLi(Li li) {
            if (this.ul == null) {
                this.ul = new Ul(li);
                FicheUtils.populate(this.ul, this.initAtts);
            } else {
                this.ul.add(li);
            }
            this.lastLi = li;
        }

        private void addP(P p) {
            if (this.lastLi == null) {
                this.addLi(new Li(p));
            } else {
                this.lastLi.add(p);
            }
        }

        private void addUl(UlBuffer ulBuffer) {
            if (ulBuffer.ul != null) {
                this.lastLi.add(ulBuffer.ul);
            }
        }
    }
}

