/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.StringUtils;

public class DocumentChangeInfo {
    public static final DocumentChangeInfo EMPTY = new DocumentChangeInfo();
    private final List<FileName> tmpFileNameList = new ArrayList<FileName>();
    private final List<String> removedExtensionList = new ArrayList<String>();
    private String newBasename;

    private DocumentChangeInfo() {
    }

    public String getNewBasename() {
        return this.newBasename;
    }

    public int getTmpFileCount() {
        return this.tmpFileNameList.size();
    }

    public FileName getTmpFileName(int i) {
        return this.tmpFileNameList.get(i);
    }

    public int getRemovedExtensionCount() {
        return this.removedExtensionList.size();
    }

    public String getRemovedExtension(int i) {
        return this.removedExtensionList.get(i);
    }

    public static DocumentChangeInfo parse(String s) {
        String[] params = StringUtils.getTokens(s, ',', (short)2);
        DocumentChangeInfo documentChangeInfo = new DocumentChangeInfo();
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            String[] couple = StringUtils.getTokens(params[i], '=', (short)2);
            if (couple.length != 2) continue;
            String key = couple[0];
            String value = couple[1];
            if (key.equals("bn")) {
                documentChangeInfo.newBasename = value;
                continue;
            }
            if (key.equals("tf")) {
                FileName fileName = DocumentChangeInfo.parseTmpFileName(value);
                if (fileName == null) continue;
                documentChangeInfo.tmpFileNameList.add(fileName);
                continue;
            }
            if (!key.equals("re")) continue;
            documentChangeInfo.removedExtensionList.add(value);
        }
        return documentChangeInfo;
    }

    public static FileName parseTmpFileName(String s) {
        FileName fileName;
        try {
            fileName = FileName.parse(s);
        }
        catch (ParseException pe) {
            return null;
        }
        if (!AddendaUtils.testExtension(fileName.getExtension())) {
            return null;
        }
        return fileName;
    }
}

