/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import net.fichotheque.importation.LiensImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.utils.FichothequeUtils;

public class LiensImportBuilder {
    private final Set<IncludeKey> removedIncludeKeySet = new HashSet<IncludeKey>();
    private final Set<IncludeKey> replaceIncludeKeySet = new HashSet<IncludeKey>();
    private final List<LiensImport.LienImport> replaceList = new ArrayList<LiensImport.LienImport>();
    private final List<LiensImport.LienImport> appendList = new ArrayList<LiensImport.LienImport>();
    private int liageStatus = 0;

    public void setLiageRemoved() {
        this.liageStatus = Math.max(this.liageStatus, 1);
    }

    public void addRemovedIncludeKey(IncludeKey includeKey) {
        if (!this.replaceIncludeKeySet.contains(includeKey)) {
            this.removedIncludeKeySet.add(includeKey);
        }
    }

    public void addReplaceLienImport(LiensImport.LienImport lienImport) {
        if (lienImport.isLiageOrigin()) {
            this.liageStatus = 2;
        } else {
            IncludeKey includeKey = lienImport.getOriginIncludeKey();
            this.removedIncludeKeySet.remove(includeKey);
            this.replaceIncludeKeySet.add(includeKey);
        }
        this.replaceList.add(lienImport);
    }

    public void addAppendLienImport(LiensImport.LienImport lienImport) {
        this.appendList.add(lienImport);
    }

    public void merge(LiensImportBuilder otherLiensImportBuilder) {
        for (IncludeKey otherIncludeKey : otherLiensImportBuilder.removedIncludeKeySet) {
            this.addRemovedIncludeKey(otherIncludeKey);
        }
        for (LiensImport.LienImport lienImport : otherLiensImportBuilder.replaceList) {
            this.addReplaceLienImport(lienImport);
        }
        for (LiensImport.LienImport lienImport : otherLiensImportBuilder.appendList) {
            this.addAppendLienImport(lienImport);
        }
        this.liageStatus = Math.max(this.liageStatus, otherLiensImportBuilder.liageStatus);
    }

    public LiensImport toLiensImport() {
        List<IncludeKey> removedIncludeKeyList = FichothequeUtils.wrap(this.removedIncludeKeySet.toArray(new IncludeKey[this.removedIncludeKeySet.size()]));
        return new InternalLiensImport(this.liageStatus == 1, removedIncludeKeyList, LiensImportBuilder.wrap(this.replaceList), LiensImportBuilder.wrap(this.appendList));
    }

    private static List<LiensImport.LienImport> wrap(List<LiensImport.LienImport> list) {
        return new LienImportList(list.toArray(new LiensImport.LienImport[list.size()]));
    }

    private static class InternalLiensImport
    implements LiensImport {
        private final boolean liageRemoved;
        private final List<IncludeKey> removedIncludeKeyList;
        private final List<LiensImport.LienImport> replaceList;
        private final List<LiensImport.LienImport> appendList;

        private InternalLiensImport(boolean liageRemoved, List<IncludeKey> removedIncludeKeyList, List<LiensImport.LienImport> replaceList, List<LiensImport.LienImport> appendList) {
            this.liageRemoved = liageRemoved;
            this.removedIncludeKeyList = removedIncludeKeyList;
            this.replaceList = replaceList;
            this.appendList = appendList;
        }

        @Override
        public boolean isLiageRemoved() {
            return this.liageRemoved;
        }

        @Override
        public List<IncludeKey> getRemovedIncludeKeyList() {
            return this.removedIncludeKeyList;
        }

        @Override
        public List<LiensImport.LienImport> getReplaceLienImportList() {
            return this.replaceList;
        }

        @Override
        public List<LiensImport.LienImport> getAppendLienImportList() {
            return this.appendList;
        }
    }

    private static class LienImportList
    extends AbstractList<LiensImport.LienImport>
    implements RandomAccess {
        private final LiensImport.LienImport[] array;

        private LienImportList(LiensImport.LienImport[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public LiensImport.LienImport get(int index) {
            return this.array[index];
        }
    }
}

