/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public final class TagUtils {
    public static final short BLOCK_TYPE = 1;
    public static final short INLINE_TYPE = 2;
    public static final short CDATA_TYPE = 3;

    private TagUtils() {
    }

    public static short getTagType(Element element) {
        switch (element.tagName()) {
            case "iframe": 
            case "audio": 
            case "video": 
            case "object": {
                return 3;
            }
            case "del": 
            case "ins": {
                if (TagUtils.containsBlock(element)) {
                    return 1;
                }
                return 2;
            }
            case "br": {
                return 2;
            }
        }
        if (element.isBlock()) {
            return 1;
        }
        return 2;
    }

    public static boolean isInline(Element element) {
        return TagUtils.getTagType(element) == 2;
    }

    public static Element getLoneChild(Element parent) {
        Node child;
        if (parent.childNodeSize() == 1 && (child = parent.childNode(0)) instanceof Element) {
            return (Element)child;
        }
        Element loneChild = null;
        for (Node node : parent.childNodes()) {
            String text;
            if (node instanceof Element) {
                if (loneChild == null) {
                    loneChild = (Element)node;
                    continue;
                }
                return null;
            }
            if (!(node instanceof TextNode) || (text = ((TextNode)node).text()).trim().length() <= 0) continue;
            return null;
        }
        return loneChild;
    }

    private static boolean containsBlock(Element element) {
        for (Element child : element.children()) {
            if (TagUtils.isInline(child)) continue;
            return true;
        }
        return false;
    }
}

