/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.DocumentFormatter;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FormatterUtils;

public class DocumentTokenizer
implements Tokenizer {
    private final Addenda addenda;
    private final DocumentFormatter documentFormatter;
    private final String mode;
    private final int weightFilter;
    private final boolean globalSelect;

    public DocumentTokenizer(Addenda addenda, DocumentFormatter documentFormatter, String mode, int weightFilter, boolean globalSelect) {
        this.documentFormatter = documentFormatter;
        this.addenda = addenda;
        this.mode = mode;
        this.weightFilter = weightFilter;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        Croisements croisements;
        ArrayList<Liaison> liaisons;
        if (!formatSource.getSubsetAccessPredicate().test(this.addenda)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Predicate<SubsetItem> predicate = null;
        if (this.globalSelect) {
            predicate = formatSource.getGlobalPredicate();
        }
        if ((liaisons = new ArrayList<Liaison>(CroisementUtils.filter(croisements = formatSource.getSubsetItemPointeur().getCroisements(this.addenda), this.mode, this.weightFilter))).isEmpty()) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(liaisons, this.documentFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final List<Liaison> liaisonList;
        private final DocumentFormatter documentFormatter;
        private final FormatSource formatSource;

        private InternalTokens(List<Liaison> liaisonList, DocumentFormatter documentFormatter, FormatSource formatSource) {
            this.liaisonList = liaisonList;
            this.documentFormatter = documentFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.liaisonList.size();
        }

        @Override
        public String get(int i) {
            Liaison liaison = this.liaisonList.get(i);
            return this.documentFormatter.formatDocument((Document)liaison.getSubsetItem(), liaison.getLien().getWeight(), this.formatSource);
        }
    }
}

