/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.tools.format.formatters.FormatterParserUtils;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class ValueFormatterParser {
    private static final ValueFormatter VALUE_PART = (value, formatSource) -> value;
    private static final ValueFormatter VALUE_UP_PART = (value, formatSource) -> FormatterParserUtils.toUppercase(value, formatSource);

    private ValueFormatterParser() {
    }

    public static ValueFormatter parse(String pattern, InstructionResolverProvider provider, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.value();
        }
        try {
            return ValueFormatterParser.parse(pattern, provider);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static ValueFormatter parse(String pattern, InstructionResolverProvider provider) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(provider), pattern);
        return new InternalValueFormatter(partArray);
    }

    public static boolean withToUppercaseInstruction(Instruction instruction) {
        for (Argument argument : instruction) {
            String key = argument.getKey();
            if (!key.equals("up")) continue;
            return true;
        }
        return false;
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;

        private InternalInstructionResolver(InstructionResolverProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(ValueFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return VALUE_PART;
                }
                case "value": {
                    if (FormatterParserUtils.isUppercase(instruction)) {
                        return VALUE_UP_PART;
                    }
                    return VALUE_PART;
                }
            }
            return null;
        }
    }

    private static class InternalValueFormatter
    implements ValueFormatter {
        private final Object[] partArray;

        private InternalValueFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatValue(String value, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                ValueFormatter formatter = (ValueFormatter)obj;
                buf.append(formatter.formatValue(value, formatSource));
            }
            return buf.toString();
        }
    }
}

