/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import net.fichotheque.tools.extraction.syntaxes.AbstractStepResolver;

public final class XmlResolver
extends AbstractStepResolver {
    private static final short ERROR_STEP = 0;
    private static final short START_STEP = 1;
    private static final short TAG_STEP = 2;
    private static final short ATTRIBUTE_STEP = 3;
    private static final short ONQUOTE_STEP = 5;
    private static final short WAITING_ATTRIBUTE_OPERATOR_STEP = 11;
    private static final short WAITING_TAG_STEP = 12;
    private static final short WAITING_TAG_CONTENT_STEP = 13;
    private static final short WAITING_QUOTE_STEP = 14;
    private static final short NAMESPACE_STEP = 20;
    private static final short ATTRIBUTE_NAMESPACE_STEP = 21;
    private int step = 1;
    private char currentQuote;

    private XmlResolver() {
    }

    @Override
    public void resolveChar(char carac) {
        switch (carac) {
            case ' ': {
                this.resolveSpace();
                break;
            }
            default: {
                this.appendChar(carac);
            }
        }
    }

    private void resolveSpace() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 0: 
            case 1: 
            case 5: 
            case 12: {
                appendToCurrent = true;
                break;
            }
            case 2: {
                this.flush();
                this.step = 13;
                break;
            }
            case 3: {
                this.flush();
                this.step = 11;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(' ');
        } else {
            this.appendSpaceToFinal();
        }
    }

    private void appendChar(char carac) {
        boolean appendToCurrent = true;
        block0 : switch (this.step) {
            case 1: {
                switch (carac) {
                    case '<': {
                        this.flush();
                        this.appendXmlChar("<");
                        this.step = 2;
                        appendToCurrent = false;
                        break;
                    }
                    case '@': {
                        this.flush();
                        this.appendToFinal("cm-xml-attr-arobase", "@");
                        this.step = 3;
                        appendToCurrent = false;
                    }
                }
                break;
            }
            case 3: {
                switch (carac) {
                    case '=': {
                        this.flush();
                        this.appendOperator("=");
                        this.step = 14;
                        appendToCurrent = false;
                        break;
                    }
                    case ':': {
                        this.step = 21;
                        this.flush();
                        this.appendOperator(":");
                        appendToCurrent = false;
                        this.step = 3;
                    }
                }
                break;
            }
            case 2: {
                switch (carac) {
                    case '>': {
                        this.flush();
                        this.appendXmlChar(">");
                        this.step = 12;
                        appendToCurrent = false;
                        break;
                    }
                    case '/': {
                        this.flush();
                        this.appendXmlChar("/");
                        appendToCurrent = false;
                        break;
                    }
                    case ':': {
                        this.step = 20;
                        this.flush();
                        this.appendOperator(":");
                        appendToCurrent = false;
                        this.step = 2;
                    }
                }
                break;
            }
            case 5: {
                if (carac != this.currentQuote) break;
                this.appendToCurrent(carac);
                this.flush();
                this.step = 13;
                appendToCurrent = false;
                break;
            }
            case 11: {
                switch (carac) {
                    case '=': {
                        this.appendOperator("=");
                        appendToCurrent = false;
                        this.step = 14;
                        break block0;
                    }
                }
                this.step = 0;
                break;
            }
            case 12: {
                switch (carac) {
                    case '<': {
                        this.flush();
                        this.appendXmlChar("<");
                        this.step = 2;
                        appendToCurrent = false;
                    }
                }
                break;
            }
            case 13: {
                switch (carac) {
                    case '>': {
                        this.appendXmlChar(">");
                        this.step = 12;
                        appendToCurrent = false;
                        break block0;
                    }
                    case '/': {
                        this.step = 2;
                        break block0;
                    }
                }
                this.step = 3;
                break;
            }
            case 14: {
                switch (carac) {
                    case '\"': 
                    case '\'': {
                        this.currentQuote = carac;
                        this.step = 5;
                        break block0;
                    }
                }
                this.step = 0;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(carac);
        }
    }

    private void appendXmlChar(String text) {
        this.appendToFinal("cm-xml-char", text);
    }

    @Override
    public String getStepClassName(String textPart, boolean end) {
        switch (this.step) {
            case 2: {
                return "cm-xml-tag";
            }
            case 3: {
                return "cm-xml-attr-name";
            }
            case 0: {
                return "cm-error";
            }
            case 5: {
                return "cm-string";
            }
            case 20: {
                return "cm-xml-namespace";
            }
            case 21: {
                return "cm-xml-attr-ns";
            }
        }
        return null;
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        XmlResolver resolver = new XmlResolver();
        resolver.resolveText(value);
        return resolver.end();
    }
}

