/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import net.fichotheque.tools.extraction.syntaxes.AbstractStepResolver;

public class UicomponentResolver
extends AbstractStepResolver {
    private static final String MASTER_PREFIX = "_master_";
    private static final short SUBSET_FAMILY = 1;
    private static final short COMMENT_FAMILY = 2;
    private static final short FIELD_FAMILY = 3;
    private static final short UNIQUE_FAMILY = 4;
    private short family;
    private int tokenPosition = 1;

    private UicomponentResolver() {
    }

    @Override
    public void resolveChar(char carac) {
        switch (carac) {
            case '_': {
                this.resolveSeparator();
                break;
            }
            default: {
                this.appendChar(carac);
            }
        }
    }

    @Override
    public String getStepClassName(String textPart, boolean lastPart) {
        if (this.tokenPosition == 1) {
            switch (textPart) {
                case "corpus": 
                case "thesaurus": 
                case "album": 
                case "addenda": {
                    this.family = 1;
                    return "cm-component-subset";
                }
                case "liage": 
                case "parentage": {
                    this.family = (short)4;
                    return "cm-component-subset";
                }
                case "comment": {
                    this.family = (short)2;
                    return "cm-component-comment";
                }
                case "title": 
                case "subtitle": 
                case "owners": 
                case "lang": 
                case "titre": 
                case "soustitre": 
                case "redacteurs": {
                    this.family = (short)4;
                    return "cm-component-field";
                }
            }
            this.family = (short)3;
            return "cm-component-field";
        }
        switch (this.family) {
            case 1: {
                if (this.tokenPosition == 2) {
                    return "cm-quote";
                }
                if (this.tokenPosition < 5) {
                    if (textPart.length() > 1) {
                        try {
                            int weight = Integer.parseInt(textPart.substring(1));
                            return "cm-number";
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return "cm-def";
                }
                return "cm-error";
            }
            case 2: {
                if (this.tokenPosition == 2) {
                    return "cm-quote";
                }
                return "cm-error";
            }
            case 4: {
                return "cm-error";
            }
            case 3: {
                if (this.tokenPosition == 2) {
                    return "cm-quote";
                }
                if (this.tokenPosition == 3) {
                    return "cm-string";
                }
                if (this.tokenPosition == 4) {
                    return "cm-string-2";
                }
                return "cm-error";
            }
        }
        return "cm-error";
    }

    private void resolveSeparator() {
        this.flush();
        ++this.tokenPosition;
        this.appendToCurrent('_');
    }

    private void appendChar(char carac) {
        this.appendToCurrent(carac);
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        UicomponentResolver resolver = new UicomponentResolver();
        if (value.startsWith(MASTER_PREFIX)) {
            resolver.appendToFinal("cm-qualifier", MASTER_PREFIX);
            value = value.substring(MASTER_PREFIX.length());
        }
        resolver.resolveText(value);
        return resolver.end();
    }
}

