/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.Locale;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.extraction.run.FieldsGroupParams;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.mapeadores.util.text.alphabet.Alphabet;
import net.mapeadores.util.text.alphabet.AlphabeticEntry;
import net.mapeadores.util.text.collation.group.CollationGroupBuilder;
import net.mapeadores.util.text.collation.group.ObjectWrapper;

public class FieldsEngine
extends GroupEngine {
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;
    private boolean alphabetMode = false;
    private final FieldKey[] fieldKeyArray;
    private final CollationGroupBuilder collationGroupBuilder;

    FieldsEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
        FieldsGroupParams groupParams = (FieldsGroupParams)groupClause.getGroupParams();
        this.alphabetMode = groupParams.getMode() == 1;
        this.collationGroupBuilder = new CollationGroupBuilder(Locale.getDefault());
        this.fieldKeyArray = groupParams.getFieldKeyArray();
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        String titre = this.getStringValue(ficheMeta);
        AlphabeticEntry groupClauseObject = null;
        if (this.alphabetMode) {
            AlphabeticEntry alphabeticEntry = Alphabet.newInstance(titre, ficheMeta.getLang());
            titre = alphabeticEntry.getEntryString();
            groupClauseObject = alphabeticEntry;
        }
        FicheExtractInfo info = GroupBuilder.toFicheExtractInfo(ficheMeta, ficheFilter, croisement, groupClauseObject);
        ObjectWrapper objectWrapper = ObjectWrapper.newCleanedInstance(titre, info);
        this.collationGroupBuilder.addObjectWrapper(objectWrapper);
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return FieldsEngine.toGroupArray(this.collationGroupBuilder, this.groupClause, this.subGroupEngineProvider);
    }

    private String getStringValue(FicheMeta ficheMeta) {
        FicheAPI fiche = ficheMeta.getFicheAPI(false);
        for (FieldKey fieldKey : this.fieldKeyArray) {
            Object obj = fiche.getValue(fieldKey);
            if (obj == null) continue;
            String value = "";
            if (obj instanceof String) {
                value = (String)obj;
            } else if (obj instanceof FicheItem) {
                value = this.getStringValue((FicheItem)obj);
            } else if (obj instanceof FicheItems) {
                value = this.getStringValue((FicheItems)obj);
            }
            if (value.length() <= 0) continue;
            return value;
        }
        return "";
    }

    private String getStringValue(FicheItem ficheItem) {
        if (ficheItem == null) {
            return "";
        }
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        if (ficheItem instanceof ParaItem) {
            return ((ParaItem)ficheItem).contentToString();
        }
        return "";
    }

    private String getStringValue(FicheItems ficheItems) {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            String value = this.getStringValue((FicheItem)ficheItems.get(i));
            if (value.length() <= 0) continue;
            return value;
        }
        return "";
    }
}

