/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.def.PackClause;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.TitleClause;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.utils.SelectionUtils;

public class CorpusExtractDefBuilder {
    private final Map<String, Boolean> booleanMap = new HashMap<String, Boolean>();
    private final Map<String, Object> clauseMap = new HashMap<String, Object>();
    private FicheFilter ficheFilter;
    private String name = null;
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private List<FicheCondition.Entry> ficheQueryList = SelectionUtils.EMPTY_FICHECONDITIONENTRYLIST;

    public CorpusExtractDefBuilder() {
    }

    public CorpusExtractDefBuilder(FicheFilter ficheFilter) {
        if (ficheFilter == null) {
            throw new IllegalArgumentException("ficheFilter is null");
        }
        this.ficheFilter = ficheFilter;
    }

    public CorpusExtractDefBuilder setFicheFilter(FicheFilter ficheFilter) {
        if (ficheFilter == null) {
            throw new IllegalArgumentException("ficheFilter is null");
        }
        this.ficheFilter = ficheFilter;
        return this;
    }

    public CorpusExtractDefBuilder setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = name;
        return this;
    }

    public CorpusExtractDefBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public CorpusExtractDefBuilder setEntryList(List<FicheCondition.Entry> list) {
        this.ficheQueryList = list;
        return this;
    }

    public CorpusExtractDefBuilder setEntryList(FicheCondition.Entry ficheQuery) {
        this.ficheQueryList = Collections.singletonList(ficheQuery);
        return this;
    }

    public CorpusExtractDefBuilder setBoolean(String name, boolean value) {
        if (value) {
            this.booleanMap.put(name, Boolean.TRUE);
        } else {
            this.booleanMap.remove(name);
        }
        return this;
    }

    public CorpusExtractDefBuilder setClause(String name, Object clauseObject) {
        if (clauseObject != null) {
            switch (name) {
                case "group": {
                    clauseObject = (GroupClause)clauseObject;
                    break;
                }
                case "pack": {
                    clauseObject = (PackClause)clauseObject;
                    break;
                }
                case "title": {
                    clauseObject = (TitleClause)clauseObject;
                }
            }
            this.clauseMap.put(name, clauseObject);
        } else {
            this.clauseMap.remove(name);
        }
        return this;
    }

    public CorpusExtractDef toCorpusExtractDef() {
        if (this.ficheFilter == null) {
            throw new IllegalStateException("ficheFilter is null");
        }
        HashMap<String, Boolean> finalBooleanMap = new HashMap<String, Boolean>(this.booleanMap);
        HashMap<String, Object> finalClauseMap = new HashMap<String, Object>(this.clauseMap);
        return new InternalCorpusExtractDef(this.ficheFilter, this.name, this.tagNameInfo, this.ficheQueryList, finalBooleanMap, finalClauseMap);
    }

    public static CorpusExtractDefBuilder init() {
        return new CorpusExtractDefBuilder();
    }

    public static CorpusExtractDefBuilder init(FicheFilter ficheFilter) {
        return new CorpusExtractDefBuilder(ficheFilter);
    }

    private static class InternalCorpusExtractDef
    implements CorpusExtractDef {
        private final FicheFilter ficheFilter;
        private final String name;
        private final TagNameInfo tagNameInfo;
        private final List<FicheCondition.Entry> entryList;
        private final Map<String, Boolean> booleanMap;
        private final Map<String, Object> clauseMap;

        private InternalCorpusExtractDef(FicheFilter ficheFilter, String name, TagNameInfo tagNameInfo, List<FicheCondition.Entry> entryList, Map<String, Boolean> booleanMap, Map<String, Object> clauseMap) {
            this.ficheFilter = ficheFilter;
            this.name = name;
            this.tagNameInfo = tagNameInfo;
            this.entryList = entryList;
            this.booleanMap = booleanMap;
            this.clauseMap = clauseMap;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FicheFilter getFicheFilter() {
            return this.ficheFilter;
        }

        @Override
        public List<FicheCondition.Entry> getConditionEntryList() {
            return this.entryList;
        }

        @Override
        public boolean hasClauseObjects() {
            return !this.clauseMap.isEmpty();
        }

        @Override
        public Object getClauseObject(String name) {
            return this.clauseMap.get(name);
        }

        @Override
        public boolean hasBooleanParameters() {
            return !this.booleanMap.isEmpty();
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return this.booleanMap.containsKey(name);
        }
    }
}

