/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.Collections;
import java.util.List;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.IllustrationFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.selection.IllustrationCondition;
import net.fichotheque.utils.SelectionUtils;

public class AlbumExtractDefBuilder {
    private IllustrationFilter illustrationFilter;
    private String name = null;
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private List<IllustrationCondition.Entry> entryList = SelectionUtils.EMPTY_ILLUSTRATIONCONDITIONENTRYLIST;

    public AlbumExtractDefBuilder(IllustrationFilter illustrationFilter) {
        if (illustrationFilter == null) {
            throw new IllegalArgumentException("illustrationFilter is null");
        }
        this.illustrationFilter = illustrationFilter;
    }

    public AlbumExtractDefBuilder setIllustrationFilter(IllustrationFilter illustrationFilter) {
        if (illustrationFilter == null) {
            throw new IllegalArgumentException("illustrationFilter is null");
        }
        this.illustrationFilter = illustrationFilter;
        return this;
    }

    public AlbumExtractDefBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public AlbumExtractDefBuilder setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = name;
        return this;
    }

    public AlbumExtractDefBuilder setEntryList(List<IllustrationCondition.Entry> list) {
        this.entryList = list;
        return this;
    }

    public AlbumExtractDefBuilder setEntryList(IllustrationCondition.Entry entry) {
        this.entryList = Collections.singletonList(entry);
        return this;
    }

    public AlbumExtractDef toAlbumExtractDef() {
        return new InternalAlbumExtractDef(this.illustrationFilter, this.name, this.tagNameInfo, this.entryList);
    }

    public static AlbumExtractDefBuilder init(IllustrationFilter illustrationFilter) {
        return new AlbumExtractDefBuilder(illustrationFilter);
    }

    private static class InternalAlbumExtractDef
    implements AlbumExtractDef {
        private final IllustrationFilter illustrationFilter;
        private final String name;
        private final TagNameInfo tagNameInfo;
        private final List<IllustrationCondition.Entry> entryList;

        private InternalAlbumExtractDef(IllustrationFilter illustrationFilter, String name, TagNameInfo tagNameInfo, List<IllustrationCondition.Entry> entryList) {
            this.illustrationFilter = illustrationFilter;
            this.name = name;
            this.tagNameInfo = tagNameInfo;
            this.entryList = entryList;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IllustrationFilter getIllustrationFilter() {
            return this.illustrationFilter;
        }

        @Override
        public List<IllustrationCondition.Entry> getConditionEntryList() {
            return this.entryList;
        }
    }
}

