/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction;

import java.util.HashMap;
import java.util.Map;
import net.fichotheque.extraction.IrefConverter;

public class IrefConverterFactory {
    private int step = 1;

    private String getNewIref() {
        return String.valueOf(this.step++);
    }

    public IrefConverter newInstance() {
        return new InternalIrefConverter();
    }

    private class InternalIrefConverter
    implements IrefConverter {
        private final Map<String, String> matchingMap = new HashMap<String, String>();

        private InternalIrefConverter() {
        }

        @Override
        public String convert(String ref) {
            String existing = this.matchingMap.get(ref);
            if (existing != null) {
                return existing;
            }
            String newIref = IrefConverterFactory.this.getNewIref();
            this.matchingMap.put(ref, newIref);
            return newIref;
        }
    }
}

