/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.tools.exportation.table.NamedRangeHandler;
import net.fichotheque.tools.exportation.table.SubsetTableOdsXMLPart;
import net.fichotheque.tools.exportation.table.TableExportOds;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.opendocument.io.odtable.SheetHandler;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;
import net.mapeadores.util.io.TempStorageAppendable;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public final class TableExportOdsFactory {
    private TableExportOdsFactory() {
    }

    public static TableExportOds multi(TableExport tableExport, Fiches fiches, TableExportOdsParameters tableExportOdsParameters, OdsOptions odsOptions) {
        SelectionCheck selectionCheck = TableExportOdsFactory.check(tableExport, fiches, tableExportOdsParameters.isWithThesaurusTable());
        return TableExportOdsFactory.toTableExportOds(new MultiContentOdSource(tableExportOdsParameters, selectionCheck, odsOptions));
    }

    public static TableExportOds merge(String sheetName, TableExport tableExport, Fiches fiches, TableExportOdsParameters tableExportOdsParameters, OdsOptions odsOptions) {
        SelectionCheck selectionCheck = TableExportOdsFactory.check(tableExport, fiches, tableExportOdsParameters.isWithThesaurusTable());
        return TableExportOdsFactory.toTableExportOds(new MergeContentOdSource(sheetName, tableExportOdsParameters, selectionCheck, odsOptions));
    }

    public static TableExportOds unique(SubsetTable subsetTable, Collection<SubsetItem> subsetItems, TableExportOdsParameters tableExportOdsParameters, OdsOptions odsOptions) {
        return TableExportOdsFactory.toTableExportOds(new UniqueContentOdSource(subsetTable, subsetItems, tableExportOdsParameters, odsOptions));
    }

    private static TableExportOds toTableExportOds(ContentOdSource contentOdSource) {
        return new TableExportOds(Collections.unmodifiableList(contentOdSource.tableDefList), contentOdSource, contentOdSource.odsOptions);
    }

    private static SelectionCheck check(TableExport tableExport, Fiches fiches, boolean withThesaurusTable) {
        SelectionCheck selectionCheck = new SelectionCheck();
        HashMap<SubsetKey, SubsetTable> corpusTableMap = new HashMap<SubsetKey, SubsetTable>();
        for (SubsetTable subsetTable : tableExport.getSubsetTableList()) {
            SubsetKey subsetKey = subsetTable.getSubset().getSubsetKey();
            if (subsetKey.isCorpusSubset()) {
                corpusTableMap.put(subsetKey, subsetTable);
                continue;
            }
            if (!subsetKey.isThesaurusSubset() || !withThesaurusTable) continue;
            selectionCheck.addThesaurus(subsetTable);
        }
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            SubsetTable subsetTable = (SubsetTable)corpusTableMap.get(corpus.getSubsetKey());
            if (subsetTable == null) continue;
            selectionCheck.addCorpus(subsetTable, entry.getSubsetItemList());
        }
        return selectionCheck;
    }

    private static String getTableName(SubsetTable subsetTable, TableExportOdsParameters tableExportOdsParameters, SheetNameChecker sheetNameChecker) {
        String tableName = subsetTable.getParameterValue("table_name");
        if (tableName == null) {
            Subset subset = subsetTable.getSubset();
            switch (tableExportOdsParameters.getHeaderType()) {
                case "columntitle": {
                    tableName = FichothequeUtils.getTitle(subset, tableExportOdsParameters.getWorkingLang());
                    break;
                }
                default: {
                    tableName = subset.getSubsetKeyString();
                }
            }
        }
        tableName = sheetNameChecker.checkName(tableName);
        return tableName;
    }

    private static OdTableDef getOdTableDef(String tableName, List<ColDef> colDefList) {
        OdTableDefBuilder odTableDefBuilder = new OdTableDefBuilder(tableName);
        for (ColDef colDef : colDefList) {
            if (colDef.getCastType() == 3) {
                odTableDefBuilder.addDate();
                continue;
            }
            odTableDefBuilder.addStandard();
        }
        return odTableDefBuilder.toOdTableDef();
    }

    private static class SelectionCheck {
        private final List<SubsetTable> corpusList = new ArrayList<SubsetTable>();
        private final List<List<SubsetItem>> ficheList = new ArrayList<List<SubsetItem>>();
        private final List<SubsetTable> thesaurusList = new ArrayList<SubsetTable>();

        private SelectionCheck() {
        }

        private int getCorpusCount() {
            return this.corpusList.size();
        }

        private int getThesaurusCount() {
            return this.thesaurusList.size();
        }

        private SubsetTable getCorpusSubsetTable(int i) {
            return this.corpusList.get(i);
        }

        private SubsetTable getThesaurusSubsetTable(int i) {
            return this.thesaurusList.get(i);
        }

        private List<SubsetItem> getCorpusFicheMetaList(int i) {
            return this.ficheList.get(i);
        }

        private void addCorpus(SubsetTable subsetTable, List<SubsetItem> ficheMetaList) {
            this.corpusList.add(subsetTable);
            this.ficheList.add(ficheMetaList);
        }

        private void addThesaurus(SubsetTable subsetTable) {
            this.thesaurusList.add(subsetTable);
        }

        private boolean isEmpty() {
            return this.corpusList.isEmpty() && this.thesaurusList.isEmpty();
        }

        private int getMaxColDefCount() {
            int max = 0;
            for (SubsetTable subsetTable : this.corpusList) {
                max = Math.max(max, subsetTable.getColDefList().size());
            }
            for (SubsetTable subsetTable : this.thesaurusList) {
                max = Math.max(max, subsetTable.getColDefList().size());
            }
            return max;
        }
    }

    private static class MultiContentOdSource
    extends ContentOdSource {
        private final TableExportOdsParameters tableExportOdsParameters;
        private final SelectionCheck selectionCheck;
        private final String[] corpusTableNameArray;
        private final String[] thesaurusTableNameArray;

        private MultiContentOdSource(TableExportOdsParameters tableExportOdsParameters, SelectionCheck selectionCheck, OdsOptions odsOptions) {
            super(odsOptions);
            this.tableExportOdsParameters = tableExportOdsParameters;
            this.selectionCheck = selectionCheck;
            int corpusCount = selectionCheck.getCorpusCount();
            this.corpusTableNameArray = new String[corpusCount];
            for (int i = 0; i < corpusCount; ++i) {
                String tableName;
                SubsetTable subsetTable = selectionCheck.getCorpusSubsetTable(i);
                this.corpusTableNameArray[i] = tableName = TableExportOdsFactory.getTableName(subsetTable, tableExportOdsParameters, this.sheetNameChecker);
                this.tableDefList.add(TableExportOdsFactory.getOdTableDef(tableName, subsetTable.getColDefList()));
            }
            int thesaurusCount = selectionCheck.getThesaurusCount();
            this.thesaurusTableNameArray = new String[thesaurusCount];
            for (int i = 0; i < thesaurusCount; ++i) {
                String tableName;
                SubsetTable subsetTable = selectionCheck.getThesaurusSubsetTable(i);
                this.thesaurusTableNameArray[i] = tableName = TableExportOdsFactory.getTableName(subsetTable, tableExportOdsParameters, this.sheetNameChecker);
                this.tableDefList.add(TableExportOdsFactory.getOdTableDef(tableName, subsetTable.getColDefList()));
            }
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            AppendableXMLWriter bufferXMLWriter = XMLUtils.toXMLWriter(bodyBuffer, 3);
            SubsetTableOdsXMLPart subsetTableOdsXMLPart = new SubsetTableOdsXMLPart(bufferXMLWriter, styleManager, this.tableExportOdsParameters);
            if (this.selectionCheck.isEmpty()) {
                OdXML.openTable(bufferXMLWriter, "_empty");
                OdXML.closeTable(bufferXMLWriter);
            } else {
                int corpusLength = this.corpusTableNameArray.length;
                for (int i = 0; i < corpusLength; ++i) {
                    this.writeSubsetTable(subsetTableOdsXMLPart, this.corpusTableNameArray[i], this.selectionCheck.getCorpusSubsetTable(i), this.selectionCheck.getCorpusFicheMetaList(i));
                }
                int thesaurusLength = this.thesaurusTableNameArray.length;
                for (int i = 0; i < thesaurusLength; ++i) {
                    this.writeSubsetTable(subsetTableOdsXMLPart, this.thesaurusTableNameArray[i], this.selectionCheck.getThesaurusSubsetTable(i), null);
                }
            }
            this.writeSupplementary(subsetTableOdsXMLPart);
            this.namedRangeHandler.toXML(bufferXMLWriter);
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }

        private void writeSubsetTable(SubsetTableOdsXMLPart subsetTableOdsXMLPart, String tableName, SubsetTable subsetTable, Collection<SubsetItem> subsetItems) throws IOException {
            this.namedRangeHandler.setCurrentTableName(tableName);
            subsetTableOdsXMLPart.tableStart(tableName);
            subsetTableOdsXMLPart.addSubsetTable(tableName, subsetTable, subsetItems, 1, this.namedRangeHandler);
            subsetTableOdsXMLPart.tableEnd();
        }
    }

    private static abstract class ContentOdSource
    implements OdSource {
        protected final SheetNameChecker sheetNameChecker = new SheetNameChecker();
        private final OdsOptions odsOptions;
        private final SheetHandler supplementarySheetHandler;
        protected final List<OdTableDef> tableDefList = new ArrayList<OdTableDef>();
        protected final NamedRangeHandler namedRangeHandler = new NamedRangeHandler();

        protected ContentOdSource(OdsOptions odsOptions) {
            this.odsOptions = odsOptions;
            this.supplementarySheetHandler = odsOptions.supplementarySheetWriter() != null ? new SheetHandler(odsOptions.supplementarySheetWriter()) : null;
        }

        protected StyleManagerBuilder initBuilder() {
            StyleManagerBuilder styleManagerBuilder = new StyleManagerBuilder();
            if (this.supplementarySheetHandler != null) {
                this.supplementarySheetHandler.addSupplementary(styleManagerBuilder, this.sheetNameChecker);
            }
            styleManagerBuilder.setElementMaps(this.odsOptions.elementMaps());
            return styleManagerBuilder;
        }

        protected StyleManager initStyleManager() {
            StyleManagerBuilder styleManagerBuilder = new StyleManagerBuilder();
            if (this.supplementarySheetHandler != null) {
                this.supplementarySheetHandler.addSupplementary(styleManagerBuilder, this.sheetNameChecker);
            }
            styleManagerBuilder.setElementMaps(this.odsOptions.elementMaps());
            for (OdTableDef odTableDef : this.tableDefList) {
                styleManagerBuilder.addTableDef(odTableDef);
            }
            return styleManagerBuilder.toStyleManager();
        }

        protected void writeSupplementary(SubsetTableOdsXMLPart xmlPart) throws IOException {
            if (this.supplementarySheetHandler != null) {
                this.supplementarySheetHandler.writeSupplementary(xmlPart);
            }
        }
    }

    private static class MergeContentOdSource
    extends ContentOdSource {
        private final String tableName;
        private final TableExportOdsParameters tableExportOdsParameters;
        private final SelectionCheck selectionCheck;
        private int rowNumber = 1;

        private MergeContentOdSource(String uniqueSheetName, TableExportOdsParameters tableExportOdsParameters, SelectionCheck selectionCheck, OdsOptions odsOptions) {
            super(odsOptions);
            this.tableExportOdsParameters = tableExportOdsParameters;
            this.selectionCheck = selectionCheck;
            this.tableName = this.sheetNameChecker.checkName(uniqueSheetName);
            this.tableDefList.add(OdTableDefBuilder.buildStandard(this.tableName, selectionCheck.getMaxColDefCount()));
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            AppendableXMLWriter bufferXMLWriter = XMLUtils.toXMLWriter(bodyBuffer, 3);
            this.namedRangeHandler.setCurrentTableName(this.tableName);
            boolean first = true;
            int corpusCount = this.selectionCheck.getCorpusCount();
            SubsetTableOdsXMLPart subsetTableOdsXMLPart = new SubsetTableOdsXMLPart(bufferXMLWriter, styleManager, this.tableExportOdsParameters);
            subsetTableOdsXMLPart.tableStart(this.tableName);
            for (int i = 0; i < corpusCount; ++i) {
                this.writeSubsetRows(subsetTableOdsXMLPart, this.selectionCheck.getCorpusSubsetTable(i), this.selectionCheck.getCorpusFicheMetaList(i), first);
                first = false;
            }
            for (SubsetTable thesaurusSubsetTable : this.selectionCheck.thesaurusList) {
                this.writeSubsetRows(subsetTableOdsXMLPart, thesaurusSubsetTable, thesaurusSubsetTable.getSubset().getSubsetItemList(), first);
                first = false;
            }
            subsetTableOdsXMLPart.tableEnd();
            this.writeSupplementary(subsetTableOdsXMLPart);
            this.namedRangeHandler.toXML(bufferXMLWriter);
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }

        private void writeSubsetRows(SubsetTableOdsXMLPart subsetTableOdsXMLPart, SubsetTable subsetTable, Collection<SubsetItem> subsetItems, boolean first) throws IOException {
            String headerType = this.tableExportOdsParameters.getHeaderType();
            if (!headerType.equals("none")) {
                if (!first) {
                    subsetTableOdsXMLPart.rowStart().rowEnd().rowStart().rowEnd();
                    this.rowNumber += 2;
                }
                String title = headerType.equals("columnkey") ? subsetTable.getSubset().getSubsetKeyString() : FichothequeUtils.getTitle(subsetTable.getSubset(), this.tableExportOdsParameters.getWorkingLang());
                int rowAdded = subsetTableOdsXMLPart.addTitleRows(title);
                this.rowNumber += rowAdded;
            }
            int rowCount = subsetTableOdsXMLPart.addSubsetTable(this.tableName, subsetTable, subsetItems, this.rowNumber, this.namedRangeHandler);
            this.rowNumber += rowCount;
        }
    }

    private static class UniqueContentOdSource
    extends ContentOdSource
    implements OdSource {
        private final SubsetTable subsetTable;
        private final Collection<SubsetItem> subsetItems;
        private final TableExportOdsParameters tableExportOdsParameters;
        private final String tableName;

        private UniqueContentOdSource(SubsetTable subsetTable, Collection<SubsetItem> subsetItemList, TableExportOdsParameters tableExportOdsParameters, OdsOptions odsOptions) {
            super(odsOptions);
            this.subsetTable = subsetTable;
            this.subsetItems = subsetItemList;
            this.tableExportOdsParameters = tableExportOdsParameters;
            this.tableName = TableExportOdsFactory.getTableName(subsetTable, tableExportOdsParameters, this.sheetNameChecker);
            this.tableDefList.add(TableExportOdsFactory.getOdTableDef(this.tableName, subsetTable.getColDefList()));
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            AppendableXMLWriter bufferXMLWriter = XMLUtils.toXMLWriter(bodyBuffer, 3);
            this.namedRangeHandler.setCurrentTableName(this.tableName);
            SubsetTableOdsXMLPart subsetTableOdsXMLPart = new SubsetTableOdsXMLPart(bufferXMLWriter, styleManager, this.tableExportOdsParameters);
            subsetTableOdsXMLPart.tableStart(this.tableName);
            subsetTableOdsXMLPart.addSubsetTable(this.tableName, this.subsetTable, this.subsetItems, 1, this.namedRangeHandler);
            subsetTableOdsXMLPart.tableEnd();
            this.writeSupplementary(subsetTableOdsXMLPart);
            this.namedRangeHandler.toXML(bufferXMLWriter);
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }
    }
}

