/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.croisement;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.croisement.CroisementChangeBuilder;
import net.fichotheque.tools.croisement.CroisementChangesBuilder;

public final class CroisementRemoveParser {
    private CroisementRemoveParser() {
    }

    public static CroisementChanges parseRemove(String[] values, Fichotheque fichotheque, Predicate<SubsetItem> predicate) {
        LinkedHashMap<SubsetItem, CroisementChangeBuilder> map = new LinkedHashMap<SubsetItem, CroisementChangeBuilder>();
        for (String value : values) {
            int idx = value.indexOf(47);
            if (idx <= 0) continue;
            try {
                SubsetItem subsetItem;
                IncludeKey includeKey = IncludeKey.parse(value.substring(0, idx));
                int id = Integer.parseInt(value.substring(idx + 1));
                Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
                if (subset == null || (subsetItem = subset.getSubsetItemById(id)) == null || predicate != null && !predicate.test(subsetItem)) continue;
                CroisementChangeBuilder builder = (CroisementChangeBuilder)map.get(subsetItem);
                if (builder == null) {
                    builder = new CroisementChangeBuilder();
                    map.put(subsetItem, builder);
                }
                builder.addRemovedMode(includeKey.getMode());
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
        }
        CroisementChangesBuilder croisementChangesBuilder = new CroisementChangesBuilder();
        for (Map.Entry entry : map.entrySet()) {
            croisementChangesBuilder.addEntry((SubsetItem)entry.getKey(), ((CroisementChangeBuilder)entry.getValue()).toCroisementChange());
        }
        return croisementChangesBuilder.toCroisementChanges();
    }
}

