/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.croisement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Lien;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.croisement.CroisementChangeBuilder;
import net.fichotheque.tools.croisement.CroisementChangesBuilder;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.utils.CroisementUtils;

public class CroisementChangeEngine {
    private static final short CLEAR_EXISTING = 1;
    private static final short APPEND_AND_WEIGHT_REPLACE = 2;
    private static final short APPEND_AND_WEIGHT_MAX = 3;
    private static final short APPEND_AND_WEIGHT_NOCHANGE = 4;
    private final short changeType;
    private final SubsetItem mainSubsetItem;
    private final Map<String, NewCroisement> croisementMap = new LinkedHashMap<String, NewCroisement>();
    private final Map<SubsetKey, SubsetInfo> subsetMap = new HashMap<SubsetKey, SubsetInfo>();
    private final boolean withIncludeKeyFilter;

    private CroisementChangeEngine(short changeType, SubsetItem mainSubsetItem) {
        this.changeType = changeType;
        this.mainSubsetItem = mainSubsetItem;
        this.withIncludeKeyFilter = false;
    }

    private CroisementChangeEngine(short changeType, SubsetItem mainSubsetItem, Collection<IncludeKey> scope) {
        this.changeType = changeType;
        this.mainSubsetItem = mainSubsetItem;
        this.withIncludeKeyFilter = true;
        Fichotheque fichotheque = mainSubsetItem.getFichotheque();
        for (IncludeKey includeKey : scope) {
            Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
            if (subset == null) continue;
            this.initSubset(subset, includeKey.getMode(), includeKey.getWeightFilter());
        }
    }

    private CroisementChangeEngine() {
        this.changeType = 1;
        this.mainSubsetItem = null;
        this.withIncludeKeyFilter = false;
    }

    private void initSubset(Subset subset, String mode, int weightFilter) {
        SubsetInfo subsetInfo = this.subsetMap.get(subset.getSubsetKey());
        if (subsetInfo == null) {
            subsetInfo = new SubsetInfo(subset);
            this.subsetMap.put(subset.getSubsetKey(), subsetInfo);
        }
        subsetInfo.add(mode, weightFilter);
    }

    public void addCroisements(Croisements croisements, Predicate<SubsetItem> predicate) {
        for (Croisements.Entry entry : croisements.getEntryList()) {
            SubsetItem otherSubsetItem = entry.getSubsetItem();
            if (!predicate.test(otherSubsetItem)) continue;
            for (Lien lien : entry.getCroisement().getLienList()) {
                try {
                    this.addLien(otherSubsetItem, lien.getMode(), lien.getWeight());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void addLien(LienBuffer lienBuffer) {
        this.addLien(lienBuffer.getSubsetItem(), lienBuffer.getMode(), lienBuffer.getWeight());
    }

    public void addLien(SubsetItem otherSubsetItem, String mode, int weight) {
        if (this.isMainSubsetItem(otherSubsetItem)) {
            return;
        }
        SubsetInfo subsetInfo = this.getOrCreateSubsetInfo(otherSubsetItem);
        ModeInfo modeInfo = this.getOrCreateModeInfo(subsetInfo, mode);
        if (!modeInfo.containsWeight(weight)) {
            throw new IllegalArgumentException("Weight not declared : " + weight);
        }
        boolean mainInFirst = this.mainSubsetItem != null ? CroisementKey.getOrder(this.mainSubsetItem, otherSubsetItem) == 1 : true;
        NewLien newLien = new NewLien(otherSubsetItem, mode, weight, mainInFirst);
        boolean done = this.getOrCreateNewCroisement(otherSubsetItem).adNewLien(newLien);
        if (done) {
            subsetInfo.addNewLien(newLien);
        }
    }

    public void removeLien(SubsetItem otherSubsetItem, String mode) {
        if (this.isMainSubsetItem(otherSubsetItem)) {
            return;
        }
        SubsetInfo subsetInfo = this.getOrCreateSubsetInfo(otherSubsetItem);
        this.getOrCreateModeInfo(subsetInfo, mode);
        this.getOrCreateNewCroisement(otherSubsetItem).addRemovedMode(mode);
    }

    public CroisementChanges toCroisementChanges() {
        if (this.mainSubsetItem == null) {
            this.checkNew();
        } else {
            this.checkExisting();
        }
        CroisementChangesBuilder builder = new CroisementChangesBuilder();
        for (NewCroisement newCroisement : this.croisementMap.values()) {
            if (newCroisement.isRemoved()) {
                builder.addRemoved(newCroisement.otherSubsetItem);
                continue;
            }
            if (newCroisement.isCancelled()) continue;
            CroisementChange croisementChange = newCroisement.toCroisementChange();
            builder.addEntry(newCroisement.otherSubsetItem, croisementChange);
        }
        return builder.toCroisementChanges();
    }

    public static CroisementChangeEngine newEngine() {
        return new CroisementChangeEngine();
    }

    public static CroisementChangeEngine clearExistingEngine(SubsetItem mainSubsetItem) {
        return new CroisementChangeEngine(1, mainSubsetItem);
    }

    public static CroisementChangeEngine clearExistingEngine(SubsetItem mainSubsetItem, Collection<IncludeKey> scope) {
        return new CroisementChangeEngine(1, mainSubsetItem, scope);
    }

    public static CroisementChangeEngine appendEngine(SubsetItem mainSubsetItem) {
        return new CroisementChangeEngine(4, mainSubsetItem);
    }

    public static CroisementChangeEngine appendOrWeightReplaceEngine(SubsetItem mainSubsetItem) {
        return new CroisementChangeEngine(2, mainSubsetItem);
    }

    public static CroisementChangeEngine appendOrWeightMaxEngine(SubsetItem mainSubsetItem) {
        return new CroisementChangeEngine(3, mainSubsetItem);
    }

    private boolean isMainSubsetItem(SubsetItem otherSubsetItem) {
        return this.mainSubsetItem != null && this.mainSubsetItem.equals(otherSubsetItem);
    }

    private SubsetInfo getOrCreateSubsetInfo(SubsetItem otherSubsetItem) {
        SubsetInfo subsetInfo = this.subsetMap.get(otherSubsetItem.getSubsetKey());
        if (subsetInfo == null) {
            if (this.withIncludeKeyFilter) {
                throw new IllegalArgumentException("Subset not declared : " + otherSubsetItem.getSubsetKey());
            }
            subsetInfo = new SubsetInfo(otherSubsetItem.getSubset());
            this.subsetMap.put(otherSubsetItem.getSubsetKey(), subsetInfo);
        }
        return subsetInfo;
    }

    private ModeInfo getOrCreateModeInfo(SubsetInfo subsetInfo, String mode) {
        ModeInfo modeInfo = subsetInfo.getModeInfo(mode);
        if (modeInfo == null) {
            if (this.withIncludeKeyFilter) {
                throw new IllegalArgumentException("Mode not declared : " + mode);
            }
            modeInfo = subsetInfo.add(mode, -1);
        }
        return modeInfo;
    }

    private NewCroisement getOrCreateNewCroisement(SubsetItem otherSubsetItem) {
        String stringKey = CroisementChangeEngine.toStringKey(otherSubsetItem);
        NewCroisement newCroisement = this.croisementMap.get(stringKey);
        if (newCroisement == null) {
            newCroisement = new NewCroisement(otherSubsetItem);
            this.croisementMap.put(stringKey, newCroisement);
        }
        return newCroisement;
    }

    private void checkNew() {
        for (Map.Entry<SubsetKey, SubsetInfo> entry : this.subsetMap.entrySet()) {
            SubsetInfo subsetInfo = entry.getValue();
            PositionMaxima positionMaxima = new PositionMaxima();
            for (NewLien newLien : subsetInfo.newLienList) {
                if (newLien.isCanceled() || !newLien.isMainPositionUndefined()) continue;
                newLien.setMainPosition(positionMaxima.getNewPosition(newLien.getMode()));
            }
        }
    }

    private void checkExisting() {
        Fichotheque fichotheque = this.mainSubsetItem.getFichotheque();
        for (Map.Entry<SubsetKey, SubsetInfo> entry : this.subsetMap.entrySet()) {
            SubsetInfo subsetInfo = entry.getValue();
            Croisements currentCroisements = fichotheque.getCroisements(this.mainSubsetItem, subsetInfo.subset);
            PositionMaxima positionMaxima = new PositionMaxima();
            if (this.changeType != 1) {
                for (Croisements.Entry currentEntry : currentCroisements.getEntryList()) {
                    Croisement croisement;
                    positionMaxima.checkCroisement(croisement, (croisement = currentEntry.getCroisement()).getCroisementKey().getOrder(this.mainSubsetItem) != 1);
                }
            }
            for (Croisements.Entry currentEntry : currentCroisements.getEntryList()) {
                SubsetItem otherSubsetItem = currentEntry.getSubsetItem();
                Croisement currentCroisement = currentEntry.getCroisement();
                String key = CroisementChangeEngine.toStringKey(otherSubsetItem);
                NewCroisement newCroisement = this.croisementMap.get(key);
                if (newCroisement == null) {
                    if (this.changeType != 1) continue;
                    newCroisement = this.initRemovedNewCroisement(subsetInfo, otherSubsetItem, currentCroisement);
                    this.croisementMap.put(key, newCroisement);
                    continue;
                }
                for (Lien currentLien : currentCroisement.getLienList()) {
                    if (!subsetInfo.containsMode(currentLien.getMode())) continue;
                    newCroisement.checkCurrentLien(currentLien, this.changeType);
                }
            }
            for (NewLien newLien : subsetInfo.newLienList) {
                if (newLien.isCanceled()) continue;
                if (newLien.isMainPositionUndefined()) {
                    PositionMaxima otherPositionMaxima = subsetInfo.getMainPositionMaxima(newLien.getOtherSubsetItem(), this.mainSubsetItem.getSubset());
                    newLien.setMainPosition(otherPositionMaxima.getNewPosition(newLien.getMode()));
                }
                if (!newLien.isOtherPositionUndefined()) continue;
                newLien.setOtherPosition(positionMaxima.getNewPosition(newLien.getMode()));
            }
        }
    }

    private NewCroisement initRemovedNewCroisement(SubsetInfo subsetInfo, SubsetItem otherSubsetItem, Croisement croisement) {
        List<Lien> lienList = croisement.getLienList();
        int lienCount = lienList.size();
        int removeCount = 0;
        NewCroisement newCroisement = new NewCroisement(otherSubsetItem);
        for (Lien lien : lienList) {
            int weight;
            String mode = lien.getMode();
            ModeInfo modeInfo = subsetInfo.getModeInfo(mode);
            if (modeInfo == null || !modeInfo.containsWeight(weight = lien.getWeight())) continue;
            newCroisement.addRemovedMode(mode);
            ++removeCount;
        }
        if (removeCount == lienCount) {
            newCroisement.setRemoveAll(true);
        }
        return newCroisement;
    }

    private static String toStringKey(SubsetItem subsetItem) {
        return subsetItem.getSubsetKey() + "/" + subsetItem.getId();
    }

    private static class SubsetInfo {
        private final Fichotheque fichotheque;
        private final Subset subset;
        private final Map<String, ModeInfo> modeInfoMap = new HashMap<String, ModeInfo>();
        private List<NewLien> newLienList = new ArrayList<NewLien>();
        private final Map<Integer, PositionMaxima> maximaMap = new HashMap<Integer, PositionMaxima>();

        private SubsetInfo(Subset subset) {
            this.subset = subset;
            this.fichotheque = subset.getFichotheque();
        }

        private ModeInfo add(String mode, int weightFilter) {
            ModeInfo modeInfo = this.modeInfoMap.get(mode);
            if (modeInfo == null) {
                modeInfo = new ModeInfo(mode);
                this.modeInfoMap.put(mode, modeInfo);
            }
            modeInfo.addWeightFilter(weightFilter);
            return modeInfo;
        }

        private boolean containsMode(String mode) {
            return this.modeInfoMap.get(mode) != null;
        }

        private ModeInfo getModeInfo(String mode) {
            return this.modeInfoMap.get(mode);
        }

        private void addNewLien(NewLien newLien) {
            this.newLienList.add(newLien);
        }

        private PositionMaxima getMainPositionMaxima(SubsetItem otherSubsetItem, Subset mainSubset) {
            PositionMaxima positionMaxima = this.maximaMap.get(otherSubsetItem.getId());
            if (positionMaxima == null) {
                Croisements mainSubsetCroisements = this.fichotheque.getCroisements(otherSubsetItem, mainSubset);
                positionMaxima = new PositionMaxima();
                for (Croisements.Entry entry : mainSubsetCroisements.getEntryList()) {
                    Croisement croisement;
                    positionMaxima.checkCroisement(croisement, (croisement = entry.getCroisement()).getCroisementKey().getOrder(otherSubsetItem) != 1);
                }
                this.maximaMap.put(otherSubsetItem.getId(), positionMaxima);
            }
            return positionMaxima;
        }
    }

    private static class ModeInfo {
        private final String mode;
        private boolean allWeight = false;
        private Set<Integer> weightSet;

        private ModeInfo(String mode) {
            this.mode = mode;
        }

        private void addWeightFilter(int weightFilter) {
            if (this.allWeight) {
                return;
            }
            if (weightFilter == -1) {
                this.allWeight = true;
            } else {
                if (this.weightSet == null) {
                    this.weightSet = new HashSet<Integer>();
                }
                this.weightSet.add(weightFilter);
            }
        }

        private boolean containsWeight(int weight) {
            if (this.allWeight) {
                return true;
            }
            if (this.weightSet == null) {
                return false;
            }
            return this.weightSet.contains(weight);
        }
    }

    private static class NewLien {
        private final SubsetItem otherSubsetItem;
        private final String mode;
        private int weight;
        private int position1 = 0;
        private int position2 = 0;
        private final boolean mainIsFirst;
        private boolean canceled = false;

        private NewLien(SubsetItem otherSubsetItem, String mode, int weight, boolean mainIsFirst) {
            this.mode = mode;
            this.weight = weight;
            this.mainIsFirst = mainIsFirst;
            this.otherSubsetItem = otherSubsetItem;
        }

        private String getMode() {
            return this.mode;
        }

        private SubsetItem getOtherSubsetItem() {
            return this.otherSubsetItem;
        }

        private void setPositions(Lien currentLien) {
            this.position1 = currentLien.getPosition1();
            this.position2 = currentLien.getPosition2();
        }

        private boolean isCanceled() {
            return this.canceled;
        }

        private void cancelNewLien() {
            this.canceled = true;
        }

        private boolean isMainPositionUndefined() {
            if (this.mainIsFirst) {
                return this.position1 == 0;
            }
            return this.position2 == 0;
        }

        private boolean isOtherPositionUndefined() {
            if (this.mainIsFirst) {
                return this.position2 == 0;
            }
            return this.position1 == 0;
        }

        private void setMainPosition(int position) {
            if (this.mainIsFirst) {
                this.position1 = position;
            } else {
                this.position2 = position;
            }
        }

        private void setMainPosition(Lien currentLien) {
            if (this.mainIsFirst) {
                this.position1 = currentLien.getPosition1();
            } else {
                this.position2 = currentLien.getPosition2();
            }
        }

        private void setOtherPosition(int position) {
            if (this.mainIsFirst) {
                this.position2 = position;
            } else {
                this.position1 = position;
            }
        }
    }

    private static class NewCroisement {
        private final SubsetItem otherSubsetItem;
        private final Set<String> removedModeSet = new HashSet<String>();
        private final Map<String, NewLien> newLienMap = new HashMap<String, NewLien>();
        private boolean removeAll = false;

        private NewCroisement(SubsetItem otherSubsetItem) {
            this.otherSubsetItem = otherSubsetItem;
        }

        private boolean adNewLien(NewLien newLien) {
            String mode = newLien.getMode();
            if (this.newLienMap.containsKey(mode)) {
                return false;
            }
            this.newLienMap.put(mode, newLien);
            this.removedModeSet.remove(mode);
            return true;
        }

        private void addRemovedMode(String mode) {
            this.removedModeSet.add(mode);
            this.cancelNewLien(mode);
        }

        private void setRemoveAll(boolean removeAll) {
            this.removeAll = removeAll;
        }

        private NewLien getNewLien(String mode) {
            return this.newLienMap.get(mode);
        }

        private void cancelNewLien(String mode) {
            NewLien newLien = this.newLienMap.remove(mode);
            if (newLien != null) {
                newLien.cancelNewLien();
            }
        }

        private boolean isRemoved() {
            return this.removeAll;
        }

        private boolean isCancelled() {
            return this.removedModeSet.isEmpty() && this.newLienMap.isEmpty();
        }

        private void checkCurrentLien(Lien currentLien, short changeType) {
            String mode = currentLien.getMode();
            if (this.removedModeSet.contains(mode)) {
                return;
            }
            NewLien newLien = this.getNewLien(mode);
            if (newLien == null) {
                if (changeType == 1) {
                    this.addRemovedMode(mode);
                }
            } else if (changeType == 4) {
                this.cancelNewLien(mode);
            } else if (changeType == 3) {
                if (currentLien.getWeight() >= newLien.weight) {
                    this.cancelNewLien(mode);
                } else {
                    newLien.setPositions(currentLien);
                }
            } else if (changeType == 2) {
                if (currentLien.getWeight() == newLien.weight) {
                    this.cancelNewLien(mode);
                } else {
                    newLien.setPositions(currentLien);
                }
            } else if (changeType == 1) {
                newLien.setMainPosition(currentLien);
            }
        }

        private CroisementChange toCroisementChange() {
            ArrayList<Lien> lienList = new ArrayList<Lien>();
            for (NewLien newLien : this.newLienMap.values()) {
                if (newLien.isCanceled()) continue;
                Lien lien = CroisementUtils.toLien(newLien.getMode(), newLien.weight, newLien.position1, newLien.position2);
                lienList.add(lien);
            }
            return CroisementChangeBuilder.toCroisementChange(this.removedModeSet, lienList);
        }
    }

    private static class PositionMaxima {
        private final Map<String, PositionMax> maximumMap = new HashMap<String, PositionMax>();

        private PositionMaxima() {
        }

        private void checkCroisement(Croisement croisement, boolean firstPosition) {
            for (Lien lien : croisement.getLienList()) {
                PositionMax positionMax = this.maximumMap.get(lien.getMode());
                if (positionMax == null) {
                    positionMax = new PositionMax();
                    this.maximumMap.put(lien.getMode(), positionMax);
                }
                positionMax.checkLien(lien, firstPosition);
            }
        }

        private int getNewPosition(String mode) {
            PositionMax positionMax = this.maximumMap.get(mode);
            if (positionMax == null) {
                positionMax = new PositionMax();
                this.maximumMap.put(mode, positionMax);
            }
            return positionMax.getNewPosition();
        }
    }

    private static class PositionMax {
        private int max = 0;

        private PositionMax() {
        }

        private void checkLien(Lien lien, boolean firstPosition) {
            int pos = firstPosition ? lien.getPosition1() : lien.getPosition2();
            this.max = Math.max(this.max, pos);
        }

        private int getNewPosition() {
            ++this.max;
            return this.max;
        }
    }
}

