/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

class SectionToFicheItemField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    SectionToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        int size;
        Section ficheBlocks = fiche.getSection(this.sourceKey);
        if (ficheBlocks == null || ficheBlocks.size() == 0) {
            return;
        }
        ArrayList<FicheItem> ficheItems = new ArrayList<FicheItem>();
        boolean onlyP = this.appendPara(ficheItems, ficheBlocks);
        if (!onlyP) {
            this.addWarning("_ warning.conversion.containsnotonlyp", this.sourceKey.getKeyString());
        }
        if ((size = ficheItems.size()) == 0) {
            return;
        }
        if (this.destinationKey.isProp()) {
            FicheItem ficheItem = (FicheItem)ficheItems.get(0);
            fiche.setProp(this.destinationKey, ficheItem);
            if (size > 1) {
                this.addWarning("_ warning.conversion.manyficheblocks", this.sourceKey.getKeyString());
            }
        } else {
            fiche.appendInfo(this.destinationKey, FicheUtils.toFicheItems(ficheItems));
        }
        if (removeOldField) {
            fiche.setSection(this.sourceKey, null);
        }
    }

    private boolean appendPara(List<FicheItem> list, FicheBlocks ficheBlocks) {
        boolean onlyP = true;
        int size = ficheBlocks.size();
        for (int i = 0; i < size; ++i) {
            FicheBlock ficheBlock = (FicheBlock)ficheBlocks.get(i);
            if (!(ficheBlock instanceof P)) {
                onlyP = false;
            }
            if (ficheBlock instanceof ParagraphBlock) {
                ParaItem para = this.toPara((ParagraphBlock)((Object)ficheBlock));
                if (para == null) continue;
                list.add(para);
                continue;
            }
            if (ficheBlock instanceof Div) {
                this.appendPara(list, (Div)ficheBlock);
                continue;
            }
            if (ficheBlock instanceof Cdatadiv) {
                String s = ((Cdatadiv)ficheBlock).getCdata();
                if (s.length() <= 0) continue;
                ParaItem.Builder builder = new ParaItem.Builder();
                builder.addText(s);
                list.add(builder.toParaItem());
                continue;
            }
            if (ficheBlock instanceof Ul) {
                for (Li li : (Ul)ficheBlock) {
                    this.appendPara(list, li);
                }
                continue;
            }
            if (ficheBlock instanceof Code) {
                for (Ln ln : (Code)ficheBlock) {
                    ParaItem para = this.toPara(ln);
                    if (para == null) continue;
                    list.add(para);
                }
                continue;
            }
            if (!(ficheBlock instanceof Table)) continue;
            for (Tr tr : (Table)ficheBlock) {
                for (Td td : tr) {
                    ParaItem para = this.toPara(td);
                    if (para == null) continue;
                    list.add(para);
                }
            }
        }
        return onlyP;
    }

    private ParaItem toPara(ParagraphBlock paragraphBlock) {
        ParaItem.Builder builder = new ParaItem.Builder();
        if (paragraphBlock.isEmpty()) {
            return null;
        }
        for (Object obj : paragraphBlock) {
            if (obj instanceof S) {
                builder.addS((S)obj);
                continue;
            }
            if (!(obj instanceof String)) continue;
            builder.addText((String)obj);
        }
        return builder.toParaItem();
    }
}

