/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.alias;

import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;

public class AliasUtils {
    public static final String SEVERE_ALIAS = "severe.alias";

    private AliasUtils() {
    }

    public static boolean testDateProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "prop");
            return false;
        }
        if (!corpusField.isType("date")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "date");
            return false;
        }
        return true;
    }

    public static boolean testAmountProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "prop");
            return false;
        }
        if (!corpusField.isType("amount")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "amount");
            return false;
        }
        return true;
    }

    public static boolean testNumberProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "prop");
            return false;
        }
        if (!corpusField.isType("number")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "number");
            return false;
        }
        return true;
    }

    public static boolean testPersonProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "prop");
            return false;
        }
        if (!corpusField.isType("person")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "person");
            return false;
        }
        return true;
    }

    public static boolean testItemProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "prop");
            return false;
        }
        if (!corpusField.isType("item")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "item");
            return false;
        }
        return true;
    }

    public static boolean testDateInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "info");
            return false;
        }
        if (!corpusField.isType("date")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "date");
            return false;
        }
        return true;
    }

    public static boolean testAmountInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "info");
            return false;
        }
        if (!corpusField.isType("amount")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "amount");
            return false;
        }
        return true;
    }

    public static boolean testLanguageInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "info");
            return false;
        }
        if (!corpusField.isType("language")) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, "language");
            return false;
        }
        return true;
    }

    public static void unknownAlias(MessageHandler messageHandler, String aliasType, String alias) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias", aliasType, alias);
    }

    public static void missingSubset(MessageHandler messageHandler, String alias, SubsetKey subsetKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.subset", alias, subsetKey);
    }

    public static void missingField(MessageHandler messageHandler, String alias, FieldKey fieldKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.field", alias, fieldKey);
    }

    public static void wrongFieldCategory(MessageHandler messageHandler, String alias, CorpusField corpusField, String expectedCategories) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.fieldcategory", alias, corpusField.getFieldString(), expectedCategories);
    }

    public static void wrongFicheItemType(MessageHandler messageHandler, String alias, CorpusField corpusField, String expectedFicheItemType) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.itemtype", alias, corpusField.getFieldString(), expectedFicheItemType);
    }

    public static class ErrorHandler
    implements MessageHandler {
        private final MessageHandler wrappedHandler;
        private boolean withError = false;

        public ErrorHandler(MessageHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public boolean isWithError() {
            return this.withError;
        }

        @Override
        public void addMessage(String category, Message message) {
            if (category.equals(AliasUtils.SEVERE_ALIAS)) {
                this.withError = true;
            }
            this.wrappedHandler.addMessage(category, message);
        }
    }
}

