/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.importation;

import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.importation.LiensImport;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.primitives.FuzzyDate;

public interface CorpusImport {
    public static final String EDIT_TYPE = "edit";
    public static final String REMOVE_TYPE = "remove";

    public Corpus getCorpus();

    public String getType();

    public List<FicheImport> getFicheImportList();

    public static String checkType(String type) {
        switch (type) {
            case "creation": 
            case "change": 
            case "edit": {
                return EDIT_TYPE;
            }
            case "remove": {
                return REMOVE_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static interface CreationFicheImport
    extends EditFicheImport {
        public int getNewId();
    }

    public static interface ChangeFicheImport
    extends EditFicheImport {
    }

    public static interface EditFicheImport
    extends FicheImport {
        public FicheChange getFicheChange();

        public AttributeChange getAttributeChange();

        public LiensImport getLiensImport();

        public FuzzyDate getCreationDate();
    }

    public static interface FicheImport {
        public int getFicheId();
    }
}

