/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import net.fichotheque.impl.AbstractMotcle;
import net.fichotheque.impl.ThesaurusImpl;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;

class BabelienMotcle
extends AbstractMotcle {
    private static final Lang DEFAULT_LANG = Lang.build("zxx");
    private static final Label DEFAULT_LABEL = new NoLinguisticContentLabel();
    private static final Labels DEFAULT_LABELS = LabelUtils.toSingletonLabels(DEFAULT_LABEL);
    private Labels labels = DEFAULT_LABELS;

    public BabelienMotcle(ThesaurusImpl thesaurus, int id) {
        super(thesaurus, id);
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    boolean putLabel(Label label) {
        if (LabelUtils.areEquals((Label)this.labels.get(0), label)) {
            return false;
        }
        this.labels = label.getLang().equals(DEFAULT_LANG) ? DEFAULT_LABELS : LabelUtils.toSingletonLabels(label);
        return true;
    }

    @Override
    boolean removeLabel(Lang lang) {
        if (this.labels == DEFAULT_LABELS) {
            return false;
        }
        this.labels = DEFAULT_LABELS;
        return true;
    }

    private static class NoLinguisticContentLabel
    implements Label {
        private NoLinguisticContentLabel() {
        }

        @Override
        public String getLabelString() {
            return "?";
        }

        @Override
        public Lang getLang() {
            return DEFAULT_LANG;
        }
    }
}

