/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.history;

import java.util.Collections;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.history.CroisementHistory;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;

public final class HistoryUtils {
    public static final List<FicheHistory> EMPTY_FICHEHISTORYLIST = Collections.emptyList();
    public static final List<CroisementHistory> EMPTY_CROISEMENTHISTORYLIST = Collections.emptyList();

    private HistoryUtils() {
    }

    public static FicheHistory toFicheHistory(SubsetKey corpusKey, int id, HistoryUnit ficheUnit, HistoryUnit attributesUnit) {
        return new InternalFicheHistory(corpusKey, id, ficheUnit, attributesUnit);
    }

    public static CroisementHistory toCroisementHistory(CroisementKey croisementKey, HistoryUnit croisementUnit) {
        return new InternalCroisementHistory(croisementKey, croisementUnit);
    }

    private static class InternalFicheHistory
    implements FicheHistory {
        private final SubsetKey corpusKey;
        private final int id;
        private final HistoryUnit ficheUnit;
        private final HistoryUnit attributesUnit;

        private InternalFicheHistory(SubsetKey corpusKey, int id, HistoryUnit ficheUnit, HistoryUnit attributesUnit) {
            this.corpusKey = corpusKey;
            this.id = id;
            this.ficheUnit = ficheUnit;
            this.attributesUnit = attributesUnit;
        }

        @Override
        public SubsetKey getCorpusKey() {
            return this.corpusKey;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public HistoryUnit getFicheUnit() {
            return this.ficheUnit;
        }

        @Override
        public HistoryUnit getAttributesUnit() {
            return this.attributesUnit;
        }
    }

    private static class InternalCroisementHistory
    implements CroisementHistory {
        private final CroisementKey croisementKey;
        private final HistoryUnit croisementUnit;

        private InternalCroisementHistory(CroisementKey croisementKey, HistoryUnit croisementUnit) {
            this.croisementKey = croisementKey;
            this.croisementUnit = croisementUnit;
        }

        @Override
        public CroisementKey getCroisementKey() {
            return this.croisementKey;
        }

        @Override
        public HistoryUnit getCroisementUnit() {
            return this.croisementUnit;
        }
    }
}

